"""Initial migration

Revision ID: a7e11a2438b4
Revises:
Create Date: 2023-02-28 05:41:11.232497+00:00

"""
# pylint: disable=no-member, invalid-name, missing-function-docstring, unused-import, no-name-in-module

import sqlalchemy as sa
import sqlalchemy_utils
import sqlmodel

from alembic import op

# revision identifiers, used by Alembic.
revision = "a7e11a2438b4"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "catalog",
        sa.Column("uuid", sqlalchemy_utils.types.uuid.UUIDType(), nullable=True),
        sa.Column("created_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column("updated_at", sa.DateTime(timezone=True), nullable=True),
        sa.Column("extra_params", sa.JSON(), nullable=True),
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "engine",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("version", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("uri", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "query",
        sa.Column("id", sqlalchemy_utils.types.uuid.UUIDType(), nullable=False),
        sa.Column("catalog_name", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("engine_name", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("engine_version", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column(
            "submitted_query",
            sqlmodel.sql.sqltypes.AutoString(),
            nullable=False,
        ),
        sa.Column("async_", sa.Boolean(), nullable=False),
        sa.Column("executed_query", sqlmodel.sql.sqltypes.AutoString(), nullable=True),
        sa.Column("scheduled", sa.DateTime(), nullable=True),
        sa.Column("started", sa.DateTime(), nullable=True),
        sa.Column("finished", sa.DateTime(), nullable=True),
        sa.Column("state", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column("progress", sa.Float(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "catalogengines",
        sa.Column("catalog_id", sa.Integer(), nullable=False),
        sa.Column("engine_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["catalog_id"],
            ["catalog.id"],
        ),
        sa.ForeignKeyConstraint(
            ["engine_id"],
            ["engine.id"],
        ),
        sa.PrimaryKeyConstraint("catalog_id", "engine_id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("catalogengines")
    op.drop_table("query")
    op.drop_table("engine")
    op.drop_table("catalog")
    # ### end Alembic commands ###
