# Generated by Django 2.2.24 on 2021-06-09 14:42

from django.db import migrations, models
import django.db.models.deletion
import wagtail.core.fields
import os


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('wagtailcore', '0062_comment_models_and_pagesubscription'),
    ]

    def generate_superuser(apps, schema_editor):
        from django.contrib.auth.models import User

        DJANGO_SU_NAME = os.environ.get('DJANGO_SU_NAME', "tpierce")
        DJANGO_SU_EMAIL = os.environ.get('DJANGO_SU_EMAIL', "tim@xtendcms.com")
        DJANGO_SU_PASSWORD = os.environ.get('DJANGO_SUPERUSER_PASSWORD')

        superuser = User.objects.create_superuser(
            username=DJANGO_SU_NAME,
            email=DJANGO_SU_EMAIL,
            password=DJANGO_SU_PASSWORD)

        superuser.save()

    def rename_wagtail_admin(apps, schema_editor):
        Permission = apps.get_model('auth', 'Permission')
        perm = Permission.objects.get(codename='access_admin')
        perm.name = 'Can access Xtend CMS Admin'
        perm.save()

    operations = [
        migrations.RunPython(generate_superuser),
        migrations.RunPython(rename_wagtail_admin),
    ]
