<img align="right" src="https://user-images.githubusercontent.com/3381451/40880432-5b9e7086-66b9-11e8-9718-4b1ea4eae317.png" width="20%">

[![Build Status](https://travis-ci.org/storm-ptr/step.svg?branch=master)](https://travis-ci.org/storm-ptr/step)
[![Build Status](https://ci.appveyor.com/api/projects/status/github/storm-ptr/step?svg=true&branch=master)](https://ci.appveyor.com/project/storm-ptr/step/branch/master)

Step is a C++17, header-only library of STL-like algorithms and data structures.

### Installation

    git clone --depth 1 https://github.com/storm-ptr/step.git

### Documentation

* [doxygen](https://storm-ptr.github.io/step/)

### Table of Contents (wiki, examples)

* [edit distance](https://en.wikipedia.org/wiki/Levenshtein_distance):
  [snippet](https://github.com/storm-ptr/step/blob/master/test/edit_distance.hpp#L16-L19)
* [longest common subsequence</summary>](https://en.wikipedia.org/wiki/Longest_common_subsequence_problem):
  [snippet](https://github.com/storm-ptr/step/blob/master/test/longest_common_subsequence.hpp#L15-L19),
  [example](https://github.com/storm-ptr/step/blob/master/example/diff/utility.hpp#L80-L88)
* [longest common substring](https://en.wikipedia.org/wiki/Longest_common_substring_problem):
  [snippet](https://github.com/storm-ptr/step/blob/master/test/longest_common_substring.hpp#L13-L15)
* [longest increasing subsequence](https://en.wikipedia.org/wiki/Longest_increasing_subsequence):
  [snippet](https://github.com/storm-ptr/step/blob/master/test/longest_increasing_subsequence.hpp#L14-L17)
* [longest repeated substring](https://en.wikipedia.org/wiki/Longest_repeated_substring_problem):
  [snippet](https://github.com/storm-ptr/step/blob/master/test/longest_repeated_substring.hpp#L13-L15)
* [maximum subarray](https://en.wikipedia.org/wiki/Maximum_subarray_problem):
  [snippet](https://github.com/storm-ptr/step/blob/master/test/maximum_subarray.hpp#L13-L16)
* [suffix array](https://en.wikipedia.org/wiki/Suffix_array):
  [snippet](https://github.com/storm-ptr/step/blob/master/test/suffix.hpp#L21-L23)
* [suffix tree](https://en.wikipedia.org/wiki/Suffix_tree):
  [snippet](https://github.com/storm-ptr/step/blob/master/test/suffix.hpp#L28-L31),
  [example](https://github.com/storm-ptr/step/blob/master/example/suffix_tree_viz/utility.hpp#L30-L53)
