# This file defines how titles beginning with "Unsupported titles/" are
# handled
#
# Copyright (c) 2020 Tatu Ylonen.  See file LICENSE and https://ylonen.org

unsupported_title_map = {
    ":≠": "",
    "Ancient Greek dish": "λοπαδο­τεμαχο­σελαχο­γαλεο­κρανιο­λειψανο­δριμυ­ποτριμματο­σιλφιο­καραβο­μελιτο­κατακεχυμενο­κιχλε­πικοσσυφο­φαττο­περιστερα­λεκτρυο­νοπτο­κεφαλλιο­κιγκλο­πελειο­λαγῳο­σιραιο­βαφητραγανοπτερύγων",
    "Australian Aboriginal Flag emoticon": "[-o-]",
    "Australian Aboriginal Flag emoticon alternative": "[-0-]",
    "C sharp": "C#",
    "C through N to K": "C|N>K",
    "Colon": ":",
    "Colon capital P": ":P",
    "Colon capital thorn": ":Þ",
    "Colon equals": ":=",
    "Colon hyphen left paren": ":-(",
    "Colon hyphen right paren": ":-)",
    "Colon left paren": ":(",
    "Colon right paren": ":)",
    "Colon slash": ":/",
    "Curly brackets": "{}",
    "Double colon": "::",
    "Double period": "..",
    "Enclosing colons": ": :",
    "Enclosing less than greater than": "< >",
    "Enclosing low lines": "_ _",
    "Enclosing number signs": "# #",
    "Enclosing vertical lines": "| |",
    "Equal greater than": "=>",
    "Equal less than": "=<",
    "Full stop": ".",
    "Greater than": ">",
    "Greater than equal": ">=",
    "Greater than low line less than": ">_=",
    "HTML comment": "<!-- -->",
    "HTML start tag end tag": "< > </ >",
    "Hyphen greater than": "->",
    "Hyphen vertical line vertical line hyphen": "-||-",
    "Left curly bracket": "{",
    "Left square bracket": "[",
    "Less than": "<",
    "Less than equal": "<=",
    "Less than greater than": "<>",
    "Less than hyphen": "<-",
    "Less than slash three": "</3",
    "Less than three": "<3",
    "Less than trailing slash greater than": "< />",
    "Low line": "_",
    "Low line interfix": "-_-",
    "MeToo": "#MeToo",
    "Number sign": "#",
    "Ogham space": " ",
    "Period slash period": "./.",
    "Replacement character": "�",
    "Right curly bracket": "}",
    "Right square bracket": "]",
    "S:t": "S:t",
    "S:ta": "S:ta",
    "Space": " ",
    "Square bracketed ellipsis": "[...]",
    "Square brackets": "[ ]",
    "Thai name of Bangkok": "กรุงเทพมหานคร อมรรัตนโกสินทร์ มหินทรายุธยา มหาดิลกภพ นพรัตนราชธานีบูรีรมย์ อุดมราชนิเวศน์มหาสถาน อมรพิมานอวตารสถิต สักกะทัตติยวิษณุกรรมประสิทธิ์",
    "Vertical line": "|",
    "c:a": "c:a",
    "eq space": "eq #",
    "g tag": "<g>",
    "hr space": "hr #",
    "n:a": "n:a",
    "n:o": "n:o",
    "n:r": "n:r",
    "s:a": "s:a",
    "st:a": "st:a",
    "v:a": "v:a",
    "n:s": "n:s",
    "о slash dot": "o/.",
    "hr number sign": "hr #",
    "eq number sign": "eq #",
    "Colon small p": ":p",
    "Cifrão": "[Cifrão]",  # Should be dollar sign with two vertical lines
    "Old Israeli shekel": "[Old Israeli shekel]",  # Should be the symbol
    "Colon three": ":3",
    "Amp": "&amp;",
    "Colon lowercase thorn": ":þ",
    "Colon left curly bracket": ":{",
    ":≠": ":≠",
}
