"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../../lib");
const cache_behavior_1 = require("../../lib/private/cache-behavior");
let app;
let stack;
beforeEach(() => {
    app = new core_1.App();
    stack = new core_1.Stack(app, 'Stack', {
        env: { account: '1234', region: 'testregion' },
    });
});
test('renders the minimum template with an origin and path specified', () => {
    const origin = new lib_1.HttpOrigin('www.example.com');
    const behavior = new cache_behavior_1.CacheBehavior({
        origin,
        pathPattern: '*',
    });
    origin.bind(stack, { originIndex: 0 });
    expect(behavior._renderBehavior()).toEqual({
        targetOriginId: behavior.origin.id,
        pathPattern: '*',
        forwardedValues: { queryString: false },
        viewerProtocolPolicy: 'allow-all',
    });
});
test('renders with all properties specified', () => {
    const origin = new lib_1.HttpOrigin('www.example.com');
    const behavior = new cache_behavior_1.CacheBehavior({
        origin,
        pathPattern: '*',
        allowedMethods: lib_1.AllowedMethods.ALLOW_ALL,
        forwardQueryString: true,
        forwardQueryStringCacheKeys: ['user_id', 'auth'],
    });
    origin.bind(stack, { originIndex: 0 });
    expect(behavior._renderBehavior()).toEqual({
        targetOriginId: behavior.origin.id,
        pathPattern: '*',
        allowedMethods: ['GET', 'HEAD', 'OPTIONS', 'PUT', 'PATCH', 'POST', 'DELETE'],
        forwardedValues: {
            queryString: true,
            queryStringCacheKeys: ['user_id', 'auth'],
        },
        viewerProtocolPolicy: 'allow-all',
    });
});
//# sourceMappingURL=data:application/json;base64,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