"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const nodeunit_shim_1 = require("nodeunit-shim");
const lib_1 = require("../lib");
/* eslint-disable quote-props */
nodeunit_shim_1.nodeunitShim({
    'Origin Access Identity with automatic comment'(test) {
        const stack = new cdk.Stack();
        new lib_1.OriginAccessIdentity(stack, 'OAI');
        assert_1.expect(stack).toMatch({
            'Resources': {
                'OAIE1EFC67F': {
                    'Type': 'AWS::CloudFront::CloudFrontOriginAccessIdentity',
                    'Properties': {
                        'CloudFrontOriginAccessIdentityConfig': {
                            'Comment': 'Allows CloudFront to reach the bucket',
                        },
                    },
                },
            },
        });
        test.done();
    },
    'Origin Access Identity with comment'(test) {
        const stack = new cdk.Stack();
        new lib_1.OriginAccessIdentity(stack, 'OAI', {
            comment: 'test comment',
        });
        assert_1.expect(stack).toMatch({
            'Resources': {
                'OAIE1EFC67F': {
                    'Type': 'AWS::CloudFront::CloudFrontOriginAccessIdentity',
                    'Properties': {
                        'CloudFrontOriginAccessIdentityConfig': {
                            'Comment': 'test comment',
                        },
                    },
                },
            },
        });
        test.done();
    },
    'Builds ARN of CloudFront user'(test) {
        const stack = new cdk.Stack();
        const oai = lib_1.OriginAccessIdentity.fromOriginAccessIdentityName(stack, 'OAI', 'OAITest');
        test.ok(oai.grantPrincipal.policyFragment.principalJson.AWS[0].endsWith(':iam::cloudfront:user/CloudFront Origin Access Identity OAITest'));
        test.done();
    },
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib2FpLnRlc3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJvYWkudGVzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLDRDQUF5QztBQUN6QyxxQ0FBcUM7QUFDckMsaURBQW1EO0FBQ25ELGdDQUE4QztBQUU5QyxnQ0FBZ0M7QUFFaEMsNEJBQVksQ0FBQztJQUNYLCtDQUErQyxDQUFDLElBQVU7UUFDeEQsTUFBTSxLQUFLLEdBQUcsSUFBSSxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUM7UUFFOUIsSUFBSSwwQkFBb0IsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFFdkMsZUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLE9BQU8sQ0FDbkI7WUFDRSxXQUFXLEVBQUU7Z0JBQ1gsYUFBYSxFQUFFO29CQUNiLE1BQU0sRUFBRSxpREFBaUQ7b0JBQ3pELFlBQVksRUFBRTt3QkFDWixzQ0FBc0MsRUFBRTs0QkFDdEMsU0FBUyxFQUFFLHVDQUF1Qzt5QkFDbkQ7cUJBQ0Y7aUJBQ0Y7YUFDRjtTQUNGLENBQ0YsQ0FBQztRQUVGLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7SUFDRCxxQ0FBcUMsQ0FBQyxJQUFVO1FBQzlDLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBRTlCLElBQUksMEJBQW9CLENBQUMsS0FBSyxFQUFFLEtBQUssRUFBRTtZQUNyQyxPQUFPLEVBQUUsY0FBYztTQUN4QixDQUFDLENBQUM7UUFFSCxlQUFNLENBQUMsS0FBSyxDQUFDLENBQUMsT0FBTyxDQUNuQjtZQUNFLFdBQVcsRUFBRTtnQkFDWCxhQUFhLEVBQUU7b0JBQ2IsTUFBTSxFQUFFLGlEQUFpRDtvQkFDekQsWUFBWSxFQUFFO3dCQUNaLHNDQUFzQyxFQUFFOzRCQUN0QyxTQUFTLEVBQUUsY0FBYzt5QkFDMUI7cUJBQ0Y7aUJBQ0Y7YUFDRjtTQUNGLENBQ0YsQ0FBQztRQUVGLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7SUFFRCwrQkFBK0IsQ0FBQyxJQUFVO1FBQ3hDLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBRTlCLE1BQU0sR0FBRyxHQUFHLDBCQUFvQixDQUFDLDRCQUE0QixDQUFDLEtBQUssRUFBRSxLQUFLLEVBQUUsU0FBUyxDQUFDLENBQUM7UUFFdkYsSUFBSSxDQUFDLEVBQUUsQ0FDTCxHQUFHLENBQUMsY0FBYyxDQUFDLGNBQWMsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FDN0QsaUVBQWlFLENBQ2xFLENBQ0YsQ0FBQztRQUVGLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztJQUNkLENBQUM7Q0FDRixDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBleHBlY3QgfSBmcm9tICdAYXdzLWNkay9hc3NlcnQnO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgbm9kZXVuaXRTaGltLCBUZXN0IH0gZnJvbSAnbm9kZXVuaXQtc2hpbSc7XG5pbXBvcnQgeyBPcmlnaW5BY2Nlc3NJZGVudGl0eSB9IGZyb20gJy4uL2xpYic7XG5cbi8qIGVzbGludC1kaXNhYmxlIHF1b3RlLXByb3BzICovXG5cbm5vZGV1bml0U2hpbSh7XG4gICdPcmlnaW4gQWNjZXNzIElkZW50aXR5IHdpdGggYXV0b21hdGljIGNvbW1lbnQnKHRlc3Q6IFRlc3QpIHtcbiAgICBjb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soKTtcblxuICAgIG5ldyBPcmlnaW5BY2Nlc3NJZGVudGl0eShzdGFjaywgJ09BSScpO1xuXG4gICAgZXhwZWN0KHN0YWNrKS50b01hdGNoKFxuICAgICAge1xuICAgICAgICAnUmVzb3VyY2VzJzoge1xuICAgICAgICAgICdPQUlFMUVGQzY3Ric6IHtcbiAgICAgICAgICAgICdUeXBlJzogJ0FXUzo6Q2xvdWRGcm9udDo6Q2xvdWRGcm9udE9yaWdpbkFjY2Vzc0lkZW50aXR5JyxcbiAgICAgICAgICAgICdQcm9wZXJ0aWVzJzoge1xuICAgICAgICAgICAgICAnQ2xvdWRGcm9udE9yaWdpbkFjY2Vzc0lkZW50aXR5Q29uZmlnJzoge1xuICAgICAgICAgICAgICAgICdDb21tZW50JzogJ0FsbG93cyBDbG91ZEZyb250IHRvIHJlYWNoIHRoZSBidWNrZXQnLFxuICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICB9LFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICApO1xuXG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG4gICdPcmlnaW4gQWNjZXNzIElkZW50aXR5IHdpdGggY29tbWVudCcodGVzdDogVGVzdCkge1xuICAgIGNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjaygpO1xuXG4gICAgbmV3IE9yaWdpbkFjY2Vzc0lkZW50aXR5KHN0YWNrLCAnT0FJJywge1xuICAgICAgY29tbWVudDogJ3Rlc3QgY29tbWVudCcsXG4gICAgfSk7XG5cbiAgICBleHBlY3Qoc3RhY2spLnRvTWF0Y2goXG4gICAgICB7XG4gICAgICAgICdSZXNvdXJjZXMnOiB7XG4gICAgICAgICAgJ09BSUUxRUZDNjdGJzoge1xuICAgICAgICAgICAgJ1R5cGUnOiAnQVdTOjpDbG91ZEZyb250OjpDbG91ZEZyb250T3JpZ2luQWNjZXNzSWRlbnRpdHknLFxuICAgICAgICAgICAgJ1Byb3BlcnRpZXMnOiB7XG4gICAgICAgICAgICAgICdDbG91ZEZyb250T3JpZ2luQWNjZXNzSWRlbnRpdHlDb25maWcnOiB7XG4gICAgICAgICAgICAgICAgJ0NvbW1lbnQnOiAndGVzdCBjb21tZW50JyxcbiAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgfSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgKTtcblxuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxuXG4gICdCdWlsZHMgQVJOIG9mIENsb3VkRnJvbnQgdXNlcicodGVzdDogVGVzdCkge1xuICAgIGNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjaygpO1xuXG4gICAgY29uc3Qgb2FpID0gT3JpZ2luQWNjZXNzSWRlbnRpdHkuZnJvbU9yaWdpbkFjY2Vzc0lkZW50aXR5TmFtZShzdGFjaywgJ09BSScsICdPQUlUZXN0Jyk7XG5cbiAgICB0ZXN0Lm9rKFxuICAgICAgb2FpLmdyYW50UHJpbmNpcGFsLnBvbGljeUZyYWdtZW50LnByaW5jaXBhbEpzb24uQVdTWzBdLmVuZHNXaXRoKFxuICAgICAgICAnOmlhbTo6Y2xvdWRmcm9udDp1c2VyL0Nsb3VkRnJvbnQgT3JpZ2luIEFjY2VzcyBJZGVudGl0eSBPQUlUZXN0JyxcbiAgICAgICksXG4gICAgKTtcblxuICAgIHRlc3QuZG9uZSgpO1xuICB9LFxufSk7XG4iXX0=