"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CacheBehavior = void 0;
const distribution_1 = require("../distribution");
/**
 * Allows configuring a variety of CloudFront functionality for a given URL path pattern.
 *
 * Note: This really should simply by called 'Behavior', but this name is already taken by the legacy
 * CloudFrontWebDistribution implementation.
 */
class CacheBehavior {
    constructor(props) {
        this.props = props;
        this.origin = props.origin;
    }
    /**
     * Creates and returns the CloudFormation representation of this behavior.
     * This renders as a "CacheBehaviorProperty" regardless of if this is a default
     * cache behavior or not, as the two are identical except that the pathPattern
     * is omitted for the default cache behavior.
     *
     * @internal
     */
    _renderBehavior() {
        var _a, _b, _c;
        return {
            pathPattern: this.props.pathPattern,
            targetOriginId: this.origin.id,
            allowedMethods: (_b = (_a = this.props.allowedMethods) === null || _a === void 0 ? void 0 : _a.methods) !== null && _b !== void 0 ? _b : undefined,
            forwardedValues: {
                queryString: (_c = this.props.forwardQueryString) !== null && _c !== void 0 ? _c : false,
                queryStringCacheKeys: this.props.forwardQueryStringCacheKeys,
            },
            viewerProtocolPolicy: distribution_1.ViewerProtocolPolicy.ALLOW_ALL,
            lambdaFunctionAssociations: this.props.edgeLambdas
                ? this.props.edgeLambdas.map(edgeLambda => {
                    if (edgeLambda.functionVersion.version === '$LATEST') {
                        throw new Error('$LATEST function version cannot be used for Lambda@Edge');
                    }
                    return {
                        lambdaFunctionArn: edgeLambda.functionVersion.functionArn,
                        eventType: edgeLambda.eventType.toString(),
                    };
                })
                : undefined,
        };
    }
}
exports.CacheBehavior = CacheBehavior;
//# sourceMappingURL=data:application/json;base64,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