"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnUserMemberOfProject = exports.CfnUserMemberOfProjectPropsAccessLevel = exports.toJson_CfnUserMemberOfProjectProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnUserMemberOfProjectProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnUserMemberOfProjectProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ProjectId': obj.projectId,
        'UserId': obj.userId,
        'Username': obj.username,
        'AccessLevel': obj.accessLevel,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnUserMemberOfProjectProps = toJson_CfnUserMemberOfProjectProps;
/* eslint-enable max-len, quote-props */
/**
 * The access level to grant to this user on the project, e.g. 'Guest', 'Developer', or 'Maintainer'. Note the GitLab API may not allow all values.
 *
 * @schema CfnUserMemberOfProjectPropsAccessLevel
 */
var CfnUserMemberOfProjectPropsAccessLevel;
(function (CfnUserMemberOfProjectPropsAccessLevel) {
    /** None */
    CfnUserMemberOfProjectPropsAccessLevel["NONE"] = "None";
    /** Minimal Access */
    CfnUserMemberOfProjectPropsAccessLevel["MINIMAL_ACCESS"] = "Minimal Access";
    /** Guest */
    CfnUserMemberOfProjectPropsAccessLevel["GUEST"] = "Guest";
    /** Reporter */
    CfnUserMemberOfProjectPropsAccessLevel["REPORTER"] = "Reporter";
    /** Developer */
    CfnUserMemberOfProjectPropsAccessLevel["DEVELOPER"] = "Developer";
    /** Maintainer */
    CfnUserMemberOfProjectPropsAccessLevel["MAINTAINER"] = "Maintainer";
    /** Owner */
    CfnUserMemberOfProjectPropsAccessLevel["OWNER"] = "Owner";
    /** Admin */
    CfnUserMemberOfProjectPropsAccessLevel["ADMIN"] = "Admin";
})(CfnUserMemberOfProjectPropsAccessLevel = exports.CfnUserMemberOfProjectPropsAccessLevel || (exports.CfnUserMemberOfProjectPropsAccessLevel = {}));
/**
 * A CloudFormation `GitLab::Projects::UserMemberOfProject`
 *
 * @cloudformationResource GitLab::Projects::UserMemberOfProject
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-gitlab-resource-providers.git
 */
class CfnUserMemberOfProject extends cdk.CfnResource {
    /**
     * Create a new `GitLab::Projects::UserMemberOfProject`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnUserMemberOfProject.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnUserMemberOfProjectProps(props) });
        this.props = props;
        this.attrMembershipId = cdk.Token.asString(this.getAtt('MembershipId'));
    }
}
exports.CfnUserMemberOfProject = CfnUserMemberOfProject;
_a = JSII_RTTI_SYMBOL_1;
CfnUserMemberOfProject[_a] = { fqn: "@cdk-cloudformation/gitlab-projects-usermemberofproject.CfnUserMemberOfProject", version: "1.2.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnUserMemberOfProject.CFN_RESOURCE_TYPE_NAME = "GitLab::Projects::UserMemberOfProject";
//# sourceMappingURL=data:application/json;base64,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