import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Adds a user as a member of a GitLab project
 *
 * @schema CfnUserMemberOfProjectProps
 */
export interface CfnUserMemberOfProjectProps {
    /**
     * ID of the project to which the user should be added
     *
     * @schema CfnUserMemberOfProjectProps#ProjectId
     */
    readonly projectId: number;
    /**
     * ID (numeric) of the user to add to the project. Either this or Username but not both should be supplied.
     *
     * @schema CfnUserMemberOfProjectProps#UserId
     */
    readonly userId?: number;
    /**
     * Username (handle, e.g. often written starting with '@') of the user to add to the project. Either this or the UserId but not both should be supplied.
     *
     * @schema CfnUserMemberOfProjectProps#Username
     */
    readonly username?: string;
    /**
     * The access level to grant to this user on the project, e.g. 'Guest', 'Developer', or 'Maintainer'. Note the GitLab API may not allow all values.
     *
     * @schema CfnUserMemberOfProjectProps#AccessLevel
     */
    readonly accessLevel: CfnUserMemberOfProjectPropsAccessLevel;
}
/**
 * Converts an object of type 'CfnUserMemberOfProjectProps' to JSON representation.
 */
export declare function toJson_CfnUserMemberOfProjectProps(obj: CfnUserMemberOfProjectProps | undefined): Record<string, any> | undefined;
/**
 * The access level to grant to this user on the project, e.g. 'Guest', 'Developer', or 'Maintainer'. Note the GitLab API may not allow all values.
 *
 * @schema CfnUserMemberOfProjectPropsAccessLevel
 */
export declare enum CfnUserMemberOfProjectPropsAccessLevel {
    /** None */
    NONE = "None",
    /** Minimal Access */
    MINIMAL_ACCESS = "Minimal Access",
    /** Guest */
    GUEST = "Guest",
    /** Reporter */
    REPORTER = "Reporter",
    /** Developer */
    DEVELOPER = "Developer",
    /** Maintainer */
    MAINTAINER = "Maintainer",
    /** Owner */
    OWNER = "Owner",
    /** Admin */
    ADMIN = "Admin"
}
/**
 * A CloudFormation `GitLab::Projects::UserMemberOfProject`
 *
 * @cloudformationResource GitLab::Projects::UserMemberOfProject
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-gitlab-resource-providers.git
 */
export declare class CfnUserMemberOfProject extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "GitLab::Projects::UserMemberOfProject";
    /**
     * Resource props.
     */
    readonly props: CfnUserMemberOfProjectProps;
    /**
     * Attribute `GitLab::Projects::UserMemberOfProject.MembershipId`
     * @link https://github.com/aws-ia/cloudformation-gitlab-resource-providers.git
     */
    readonly attrMembershipId: string;
    /**
     * Create a new `GitLab::Projects::UserMemberOfProject`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnUserMemberOfProjectProps);
}
