import numpy as np
import json
import csv
import os
from ..utils import _get_files_path_list


def symbol_parser_csv(folder: str, symbol_names: list=[], zip_extension=None, **kwargs):
    '''
    Parse all symbols from a folder and returns a dictionary
    '''
    symbol_dict_with_value_type = {}
    for symbs in symbol_names:
        symb_tp = _convert_symbol_name_to_tuple(symbs)
        symbol_dict_with_value_type[symb_tp] = None

    file_list = _get_files_path_list(folder=folder, zip_extension=zip_extension, file_extension='csv')
    symbol_list = []
    for file in file_list:
        symbol_name = os.path.splitext(os.path.basename(file))[0]
        if (symbol_name, 'v') in symbol_dict_with_value_type if len(symbol_dict_with_value_type) != 0 else True:
            symbol_dict = {}
            # This fields are mandatory for a parser
            symbol_dict['symbol_name'] = symbol_name
            symbol_dict['value_type']  = 'v'
            symbol_dict['path']        = file
            symbol_dict['scenario_name'] = os.path.basename(os.path.dirname(file))
            # Until here
            # you can add more (custom) attributes. It must be added also see handler.py def add_custom_attr() and be an attribute for loader
            symbol_list.append(symbol_dict)
    return symbol_list

def load_csv(path:str, symbol_name:str, keep_zeros:bool, **kwargs):
    '''
    Load custom csv file.
    '''
    folder = os.path.dirname(path)
    file_name = symbol_name
    file_data = f"{file_name}.csv"
    file_coords = f"{file_name}.json"
    path_data = os.path.join(folder, file_data)
    path_coords = os.path.join(folder, file_coords)
    with open(path_data,'r') as csvfile:
        reader = csv.reader(csvfile, delimiter=',')
        for row in reader:
            file_load_headers = row
            break
    file_load_dims = file_load_headers[:-1] # remove last column
    file_load_data =  np.loadtxt(path_data, delimiter=',', skiprows=1, dtype=object)
    index = {}
    for i, dim in enumerate(file_load_dims):
        arr = file_load_data[:,i]
        if np.char.isnumeric(arr[0]):
            arr = arr.astype(np.integer)
        index[dim] = arr
    if file_load_dims:
        value = file_load_data[:,-1].astype('float64')
    else:
        value = file_load_data.astype('float64')
    if os.path.exists(path_coords):
        with open(path_coords,'r') as jsonfile:
            coords = json.load(jsonfile)
    else:
        coords=None
    return {'data': (index, value), 'coords': coords, 'keep_zeros': keep_zeros}

