import { Grant, IGrantable } from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
import { StageOptions, IApi, IStage, StageAttributes } from '../common';
import { StageBase } from '../common/base';
import { IWebSocketApi } from './api';
/**
 * (experimental) Represents the WebSocketStage.
 *
 * @experimental
 */
export interface IWebSocketStage extends IStage {
    /**
     * (experimental) The API this stage is associated to.
     *
     * @experimental
     */
    readonly api: IWebSocketApi;
    /**
     * (experimental) The callback URL to this stage.
     *
     * You can use the callback URL to send messages to the client from the backend system.
     * https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-basic-concept.html
     * https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-how-to-call-websocket-api-connections.html
     *
     * @experimental
     */
    readonly callbackUrl: string;
}
/**
 * (experimental) Properties to initialize an instance of `WebSocketStage`.
 *
 * @experimental
 */
export interface WebSocketStageProps extends StageOptions {
    /**
     * (experimental) The WebSocket API to which this stage is associated.
     *
     * @experimental
     */
    readonly webSocketApi: IWebSocketApi;
    /**
     * (experimental) The name of the stage.
     *
     * @experimental
     */
    readonly stageName: string;
}
/**
 * (experimental) The attributes used to import existing WebSocketStage.
 *
 * @experimental
 */
export interface WebSocketStageAttributes extends StageAttributes {
    /**
     * (experimental) The API to which this stage is associated.
     *
     * @experimental
     */
    readonly api: IWebSocketApi;
}
/**
 * (experimental) Represents a stage where an instance of the API is deployed.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Stage
 */
export declare class WebSocketStage extends StageBase implements IWebSocketStage {
    /**
     * (experimental) Import an existing stage into this CDK app.
     *
     * @experimental
     */
    static fromWebSocketStageAttributes(scope: Construct, id: string, attrs: WebSocketStageAttributes): IWebSocketStage;
    /**
     * @experimental
     */
    protected readonly baseApi: IApi;
    /**
     * (experimental) The name of the stage;
     *
     * its primary identifier.
     *
     * @experimental
     */
    readonly stageName: string;
    /**
     * (experimental) The API this stage is associated to.
     *
     * @experimental
     */
    readonly api: IWebSocketApi;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: WebSocketStageProps);
    /**
     * (experimental) The websocket URL to this stage.
     *
     * @experimental
     */
    get url(): string;
    /**
     * (experimental) The callback URL to this stage.
     *
     * @experimental
     */
    get callbackUrl(): string;
    /**
     * (experimental) Grant access to the API Gateway management API for this WebSocket API Stage to an IAM principal (Role/Group/User).
     *
     * @param identity The principal.
     * @experimental
     */
    grantManagementApiAccess(identity: IGrantable): Grant;
}
