import { Resource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { IRoute } from '../common';
import { IWebSocketApi } from './api';
import { IWebSocketRouteAuthorizer } from './authorizer';
import { WebSocketRouteIntegration } from './integration';
/**
 * (experimental) Represents a Route for an WebSocket API.
 *
 * @experimental
 */
export interface IWebSocketRoute extends IRoute {
    /**
     * (experimental) The WebSocket API associated with this route.
     *
     * @experimental
     */
    readonly webSocketApi: IWebSocketApi;
    /**
     * (experimental) The key to this route.
     *
     * @experimental
     * @attribute true
     */
    readonly routeKey: string;
}
/**
 * (experimental) Options used to add route to the API.
 *
 * @experimental
 */
export interface WebSocketRouteOptions {
    /**
     * (experimental) The integration to be configured on this route.
     *
     * @experimental
     */
    readonly integration: WebSocketRouteIntegration;
    /**
     * (experimental) The authorize to this route.
     *
     * You can only set authorizer to a $connect route.
     *
     * @default - No Authorizer
     * @experimental
     */
    readonly authorizer?: IWebSocketRouteAuthorizer;
}
/**
 * (experimental) Properties to initialize a new Route.
 *
 * @experimental
 */
export interface WebSocketRouteProps extends WebSocketRouteOptions {
    /**
     * (experimental) The API the route is associated with.
     *
     * @experimental
     */
    readonly webSocketApi: IWebSocketApi;
    /**
     * (experimental) The key to this route.
     *
     * @experimental
     */
    readonly routeKey: string;
    /**
     * (experimental) Whether the route requires an API Key to be provided.
     *
     * @default false
     * @experimental
     */
    readonly apiKeyRequired?: boolean;
}
/**
 * (experimental) Route class that creates the Route for API Gateway WebSocket API.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Route
 */
export declare class WebSocketRoute extends Resource implements IWebSocketRoute {
    /**
     * (experimental) Id of the Route.
     *
     * @experimental
     */
    readonly routeId: string;
    /**
     * (experimental) The WebSocket API associated with this route.
     *
     * @experimental
     */
    readonly webSocketApi: IWebSocketApi;
    /**
     * (experimental) The key to this route.
     *
     * @experimental
     */
    readonly routeKey: string;
    /**
     * (experimental) Integration response ID.
     *
     * @experimental
     */
    readonly integrationResponseId?: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: WebSocketRouteProps);
}
