import { Grant, IGrantable } from 'aws-cdk-lib/aws-iam';
import { Construct } from 'constructs';
import { IApi } from '../common/api';
import { ApiBase } from '../common/base';
import { WebSocketRoute, WebSocketRouteOptions } from './route';
/**
 * (experimental) Represents a WebSocket API.
 *
 * @experimental
 */
export interface IWebSocketApi extends IApi {
}
/**
 * (experimental) Represents the currently available API Key Selection Expressions.
 *
 * @experimental
 */
export declare class WebSocketApiKeySelectionExpression {
    readonly customApiKeySelector: string;
    /**
     * (experimental) The API will extract the key value from the `x-api-key` header in the user request.
     *
     * @experimental
     */
    static readonly HEADER_X_API_KEY: WebSocketApiKeySelectionExpression;
    /**
     * (experimental) The API will extract the key value from the `usageIdentifierKey` attribute in the `context` map, returned by the Lambda Authorizer.
     *
     * See https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html
     *
     * @experimental
     */
    static readonly AUTHORIZER_USAGE_IDENTIFIER_KEY: WebSocketApiKeySelectionExpression;
    /**
     * @param customApiKeySelector The expression used by API Gateway.
     * @experimental
     */
    constructor(customApiKeySelector: string);
}
/**
 * (experimental) Props for WebSocket API.
 *
 * @experimental
 */
export interface WebSocketApiProps {
    /**
     * (experimental) Name for the WebSocket API resource.
     *
     * @default - id of the WebSocketApi construct.
     * @experimental
     */
    readonly apiName?: string;
    /**
     * (experimental) An API key selection expression.
     *
     * Providing this option will require an API Key be provided to access the API.
     *
     * @default - Key is not required to access these APIs
     * @experimental
     */
    readonly apiKeySelectionExpression?: WebSocketApiKeySelectionExpression;
    /**
     * (experimental) The description of the API.
     *
     * @default - none
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The route selection expression for the API.
     *
     * @default '$request.body.action'
     * @experimental
     */
    readonly routeSelectionExpression?: string;
    /**
     * (experimental) Options to configure a '$connect' route.
     *
     * @default - no '$connect' route configured
     * @experimental
     */
    readonly connectRouteOptions?: WebSocketRouteOptions;
    /**
     * (experimental) Options to configure a '$disconnect' route.
     *
     * @default - no '$disconnect' route configured
     * @experimental
     */
    readonly disconnectRouteOptions?: WebSocketRouteOptions;
    /**
     * (experimental) Options to configure a '$default' route.
     *
     * @default - no '$default' route configured
     * @experimental
     */
    readonly defaultRouteOptions?: WebSocketRouteOptions;
}
/**
 * (experimental) Create a new API Gateway WebSocket API endpoint.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Api
 */
export declare class WebSocketApi extends ApiBase implements IWebSocketApi {
    /**
     * (experimental) The identifier of this API Gateway API.
     *
     * @experimental
     */
    readonly apiId: string;
    /**
     * (experimental) The default endpoint for an API.
     *
     * @experimental
     */
    readonly apiEndpoint: string;
    /**
     * (experimental) A human friendly name for this WebSocket API.
     *
     * Note that this is different from `webSocketApiId`.
     *
     * @experimental
     */
    readonly webSocketApiName?: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: WebSocketApiProps);
    /**
     * (experimental) Add a new route.
     *
     * @experimental
     */
    addRoute(routeKey: string, options: WebSocketRouteOptions): WebSocketRoute;
    /**
     * (experimental) Grant access to the API Gateway management API for this WebSocket API to an IAM principal (Role/Group/User).
     *
     * @param identity The principal.
     * @experimental
     */
    grantManageConnections(identity: IGrantable): Grant;
}
