"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CurrConnectionsMomiton = void 0;
const cloudwatch = require("@aws-cdk/aws-cloudwatch");
// Reference: https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheMetrics.WhichShouldIMonitor.html#metrics-curr-connections
class CurrConnectionsMomiton {
    static setup(scope, cacheClusterId, period, threshold) {
        return new cloudwatch.Alarm(scope, 'alarm-elastc-cache-' + cacheClusterId + '-CurrConnections', {
            alarmName: `ElasticCacheCurrConnectionsAlarm[${cacheClusterId}]`,
            metric: new cloudwatch.Metric({
                namespace: 'AWS/ElastiCache',
                metricName: 'CurrConnections',
                dimensions: { CacheClusterId: cacheClusterId },
                statistic: 'avg',
            }),
            threshold,
            period,
            evaluationPeriods: 1,
            alarmDescription: `The connection constant in ${period.toMinutes()} minute(s) is greater than ${threshold}.`,
            comparisonOperator: cloudwatch.ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD,
            treatMissingData: cloudwatch.TreatMissingData.BREACHING,
        });
    }
}
exports.CurrConnectionsMomiton = CurrConnectionsMomiton;
//# sourceMappingURL=data:application/json;base64,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