# AUTOGENERATED! DO NOT EDIT! File to edit: 00_data_prep.ipynb (unless otherwise specified).

__all__ = ['download_santander_data', 'unzip', 'load_csv', 'clean_dates', 'add_month_feature', 'add_age_feature']

# Cell
import os
import gdown
import pandas as pd
from nbdev import export
from pathlib import Path
from zipfile import ZipFile


# Cell
def download_santander_data():
    """downloads the data from gdrive to the data folder"""
    dest = Path('data/raw/train_ver2.csv.zip')

    #only download if file not already exists
    if not dest.exists():
        dest.parent.mkdir(parents=True, exist_ok=True)

        gdown.download(
            'https://drive.google.com/uc?export=download&id=1H-dFcuqI99OkXAawsTMkmylBz3exNUgZ',
            'data/raw/train_ver2.csv.zip',
            quiet=False)
    else:
        print(f"file {dest} already exists.")

    return dest

# Cell
def unzip(path:[Path,str], dest:[Path,str]='.'):
    """unzips a given file"""
    path = Path(path)
    dest = path.parent / path.stem

    if not dest.exists():
        with ZipFile(str(path), 'r') as zipObj:
            zipObj.extractall(str(path.parent))
            print(f'extracted to {path.parent / path.stem}')
    else:
        print(f"file {dest} already exists!")

    return dest

# Cell
# laden der Daten in einen DataFrame
def load_csv(path_file:[Path, str], limit_rows=None):
    """load csv file to a pandas df"""

    if limit_rows is None:
        return pd.read_csv(
            path_file,
            dtype={
                "sexo":str,
                "ind_nuevo":str,
                "ult_fec_cli_1t":str,
                "indext":str})

    return pd.read_csv(
        path_file,
        dtype={
            "sexo":str,
            "ind_nuevo":str,
            "ult_fec_cli_1t":str,
            "indext":str},
        nrows=limit_rows
    )

# Cell
def clean_dates(df):
    """converting the dates of the df"""
    df["fecha_dato"] = pd.to_datetime(df["fecha_dato"],format="%Y-%m-%d")
    df["fecha_alta"] = pd.to_datetime(df["fecha_alta"],format="%Y-%m-%d")

# Cell
def add_month_feature(df):
    """add buy month to the features"""
    df["month"] = pd.DatetimeIndex(df["fecha_dato"]).month
    return df

def add_age_feature(df):
    """add customer age feature"""
    df["age"]   = pd.to_numeric(df["age"], errors="coerce")
    return df