# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pf2e_wealth_calculator']

package_data = \
{'': ['*'], 'pf2e_wealth_calculator': ['tables/*']}

install_requires = \
['pandas>=1.5.2,<2.0.0', 'tabulate>=0.9.0,<0.10.0']

entry_points = \
{'console_scripts': ['pf2ewc = pf2e_wealth_calculator.entry_point:entry_point']}

setup_kwargs = {
    'name': 'pf2e-wealth-calculator',
    'version': '0.2.0',
    'description': 'A simple tool for Pathfinder 2e that calculates how much your loot is worth.',
    'long_description': '# PF2e Wealth Calculator\n![tests-badge](https://github.com/D4wnstar/pf2e-wealth-calculator/actions/workflows/tests.yml/badge.svg)\n\nA simple tool to quickly get information on large batches of items, runes and precious materials for Pathfinder Second Edition.\n\n## Features\n\n - Quickly get stats for a single item directly from the command line or add all of your loot to a file and have it process everything at once.\n - Supports input from multiple files, so you can keep everything organized.\n - Automatically calculate the price, level and rarity of items made from precious materials or with runes - or both!\n - Searches every item present on the Archives of Nethys - all 4000+ of them.\n - Randomly generate items on the fly for marketplaces or encounters.\n\n## Prerequisites\n\n- Python 3.9 or above (tested on 3.9, 3.10 and 3.11)\n\n## Installation\n\n- Python (Recommended method)\n    - If you already have Python installed, simply run `pip install pf2e-wealth-calculator`\n    - > If you encounter an error, try changing `pip` to `pip3`.\n    - If you don\'t already have Python installed, you can get it from the [official website](https://www.python.org/downloads/), your operating system\'s package manager or the Microsoft Store.\n\n- Prebuilt Windows Executable\n    - If you are on Windows and don\'t want to install Python, you can download the executable file directly from the [Releases Tab](https://github.com/D4wnstar/pf2e-wealth-calculator/releases).\n    - If you choose this method, don\'t double click on the executable file to use it! It won\'t work. Instead, place it in a folder of your preference, then open a terminal in that folder (in Windows 11 you can just right click on the folder and press "Open in Terminal"). Follow the same instructions under Usage, except you change every `pf2ewc` to the name of the executable prefixed by `.\\`. For example, if you downloaded `pf2ewc-0.1.0.exe`, you can use `.\\pf2ewc-0.1.0.exe`\n    - Note that the executable takes noticeably longer to run than the Python version, so if the long startup times bother you, consider installing from Python directly.\n\n## Usage\n\nThere\'s two ways to use this script: either pass in an item name directly or make a text file containing a list of items and how many of each you want.\n\nTo pass a single item, simply run\n\n```\npf2ewc -i "your item here"\n```\n\nQuotation marks can be omitted if the item\'s name is only one word long.\n\nAlternatively, create and write a text file where you list all of your items. On each line, write the name of the item that you want (using the same name you find on the Archives of Nethys). Next, add a comma followed by how many of this item you need. You can omit it in case you only need one.\n\n> Tip: Don\'t worry about upper- and lowercase, they don\'t make a difference.\n\nFor example:\n\n```\n# Weapons and armor\n+1 striking longsword\nCold iron breastplate (low-grade)\n\n# Gear\nSunrod, 5\nLantern (Hooded), 2\nBedroll\n\n# Currency and expensive stuff\n12gp\n*35gp\n```\n\nThen open a terminal in the same folder as the text file and run\n\n```\npf2ewc your_text_file_here.txt\n```\n\n> Tip: Put quotation marks around the file name if there are any spaces in it, e.g. `pf2ewc "dungeon loot.txt"`.\n\nIf you used the previous items, it should produce the following output:\n\n```\nTotal value (converted in gp):\n  - 2 cp\n  - 4 sp\n  - 332 gp\n\nOf which:\n  - Items: 285 gp\n  - Art objects: 35 gp\n  - Currency: 12 gp\n```\n\nLet\'s unpack what\'s going on here. Firstly, every line with a `#` is ignored, so you can write whatever you want in them. They\'re useful to keep your loot files nice and tidy, so use them as you see fit.\n\nNext, the weapon has runes while the armor is made of low-grade cold iron. As you can see, the script automatically calculates how much they\'re worth without you having to tell it anything else!\n\nThen, in "Gear" section, some items are counted multiple times. This makes it easy to add any amount of items and check whether you are giving too much or too little.\n\nFinally, in the "Currency and expensive stuff" section, you can see that you can add plain currency instead of any specific item. You may notice some weird notation on the `*34gp` line. The asterisk before the number means that it\'ll be considered as an art object instead of simple currency and categorize accordingly. This is useful whenever you want to give your player some expensive item to be sold instead of coins and want to make sure you keep things separate.\n\nYou can use the `-l` or `--level` option followed by the party\'s level or two levels in the format X-Y (e.g. 2-5) to compare the items\' total value to the one PCs are supposed to come across throughout the level or range of levels you input. These expected values come from the Treasure by Level table on Page 508 of the Core Rulebook (which you can find [here](https://2e.aonprd.com/Rules.aspx?ID=581)).\n\nFor instance, running\n\n```\npf2ewc your_text_file_here.txt -l 2\n```\n\nwould add the following lines to the previous output:\n\n```\nDifference:\n  - 32 gp too much (Expected 300 gp)\n```\n\nIf you want a detailed breakdown of what you\'re giving to your players, then you can use the `-d` or `--detailed` option, which counts the levels, categories, subcategories and rarities of all of the items you input.\n\nUsing the same items as before with the `-d` option would add these lines to the output:\n\n```\nLevels:\n  - Level 4: 1\n  - Level 5: 1\n  - Level 1: 5\n  - Level 0: 5\n\nCategories:\n  - Weapons: 1\n  - Armor: 1\n  - Alchemical items: 5\n  - Adventuring gear: 3\n  - Currency: 1\n  - Art objects: 1\n\nSubcategories:\n  - Base weapons: 1\n  - Base armor: 1\n  - Alchemical tools: 5\n  - None: 5\n\nRarities:\n  - Common: 12\n```\n\nNote that items without a level, like currency, are currently considered as being level 0.\n\n## Formatting guidelines\n\n> You can also print these rules in the terminal by using `pf2ewc -f`.\n\n- PF2e Wealth Calculator is entirely case-insensitive, meaning it doesn\'t matter if the names of the items are uppercase or lowercase.\n- In the majority of cases, the spelling must be exactly the same as the one used by the Archives of Nethys (this is because this calculator uses data from the AoN). A spelling mistake will cause the script to skip the item and suggest a possible correction. Other items in the file will still be processed.\n- You can input a weapon or armor with runes etched into it and the script will automatically calculate the price, level and rarity of the item. The calculator is built with standard notation in mind, meaning it should start with the potency rune (i.e. the +1/+2/+3), followed by the striking and potency runes (if any), followed by the item itself. For instance, `+1 striking warhammer` is fine, as is `+2 greater striking frost extending halberd`. Runes ordered in a different manner usually work so long they all precede the base item, but this syntax may lead to unexpected behaviour as the script is not built with it in mind.\n- You can also input weapons, armor and items made of a precious material. As with runes, the price, level and rarity will be calculated automatically. Write the item name as you would usually: this means the material goes first, then the base item and finally the grade of the material. For example, `silver dagger (low-grade)` is correct. To cut down on typing, the grade really just needs to include "low", "standard" or "high" and it\'ll be treated the same way; `silver dagger low` will work just fine. One thing to note is that most materials can only be found at higher grades. This script _does not_ check if the material/grade pair is valid and _will_ crash if it\'s not.\n- You can combine runes and materials too! Just make sure that _all_ of the runes are placed before the material and the item, otherwise it won\'t work. Otherwise, follow the syntax from the previous two points. For example, `+1 striking ghost touch mithral flail (standard-grade)` is correct.\n- Currency is a valid item to input, which is useful in case you want to make your players find a bunch of plain old coins in a dungeon, for instance. The syntax is just what you\'d expect: the number of coins followed by the coin type. `12 gp` and `520cp` are both fine. Note that platinum pieces ("pp") are not supported. If you prepend a currency with an asterisk like `*100gp`, it\'ll be counted as an art object instead. This allows you to divide items that are only there to be sold for currency from plain currency. This is especially useful if the art objects are hard to sell and therefore don\'t represent "immediate cash", so to speak.\n- You can start a line with a `#` character to comment the line. This means it won\'t be processed by the script and is useful to mark down where the items come from.\n\n## Options\n\n`-d` or `--detailed` shows how many items of a given level, category, subcategory and rarity there are within the given input file.\n\n`-l` or `--level` followed by a number or two numbers in the X-Y format makes the calculator compare the total value of the input items to the expected total value that a party of four is supposed to find throughout the specified level(s).\n\n`-c` or `--currency` followed by a number adds an arbitrary amount of gp to the calculation.\n\n`-f` or `--format` shows helpful information on how to correctly format the text file.\n\n`-n` or `--no-conversion` prevents coins from being converted to gp automatically (some calculations use gp only, so expect values to be slightly different from what you\'d expect).\n\n`-i` or `--item` followed by the name of an item allows you to run the script without creating a file. If the item name is composed of multiple words, you must put it in quotation marks, like `-i "tengu gale blade"`.\n\n`-r` or `--random` followed by a number randomly generates that many items, picking them without restraint from every item in the game. You can follow this option with the `-l` option to restrict random generation to that level or range of levels only.\n\n`--tbl` shows the Treasure by Level table from page 508 of the Core Rulebook.\n\n## Known exceptions\n\n- Custom scrolls and wands are not supported. However, since their price only varies with spell level, you can use their general item names instead. For scrolls it\'s `nth-Level Scroll` and for wands it\'s `Magic Wand (nth-Level Spell)`, where "nth" is the spell\'s level (e.g. 1st, 2nd, etc.). For example, instead of `scroll of lightning bolt`, use `3rd-level scroll` and instead of `wand of see invisibility`, use `magic wand (2nd-level spell)`.\n- There is currently no way to apply runes to anything that doesn\'t use potency runes. This means accessories and shields with runes are currently not supported. To get around this, you can add the runes as separate items, which would give the same total value at the cost of not getting the correct item level and rarity.\n\n## License\n\nThis project is released under the [GNU GPLv3 License](https://github.com/D4wnstar/pf2e-wealth-calculator/blob/master/LICENSE). The data this program uses for its calculations is taken from the [Archives of Nethys](https://2e.aonprd.com/) and is available for use under the [Open Game License v1.0a](https://github.com/D4wnstar/pf2e-wealth-calculator/blob/master/OGL).',
    'author': 'D4wnstar',
    'author_email': 'samvignoli@proton.me',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/D4wnstar/pf2e-wealth-calculator',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
