##
# File:  ChemRefSearchDef.py
# Date:  22-Apr-2010 J. Westbrook
#
# Update:
#  13-Jun-2017 jdw add left join semantics to query definitions
##
"""
Chemical reference search definition data  -

"""


class ChemRefSearchDef(object):
    # Supported Query Types and Features
    _queryTypeDict = {
        "BIRD_ENTITY": {"autocomplete": True, "service": "rdbms", "class": "entity"},
        "BIRD_INSTANCE": {"autocomplete": True, "service": "rdbms", "class": "instance"},
        "CCD_ENTITY": {"autocomplete": True, "service": "rdbms", "class": "entity"},
        "CCD_INSTANCE": {"autocomplete": True, "service": "rdbms", "class": "instance"},
        "INDEX_MATCH_SUBSTRING": {"autocomplete": False, "service": "index", "class": "entity"},
        "INDEX_MATCH_EXACT": {"autocomplete": False, "service": "index", "class": "entity"},
        "INDEX_MATCH_RANGE_VALUE_PAIR": {"autocomplete": False, "service": "index", "class": "entity"},
        "INDEX_MATCH_SIMILAR": {"autocomplete": False, "service": "index", "class": "entity"},
        "INDEX_FORMULA_SUBSET": {"autocomplete": False, "service": "index", "class": "entity"},
        "INDEX_FORMULA_EXACT": {"autocomplete": False, "service": "index", "class": "entity"},
        "INDEX_FORMULA_EXACT_SKIPH": {"autocomplete": False, "service": "index", "class": "entity"},
        "INDEX_FORMULA_BOUNDED": {"autocomplete": False, "service": "index", "class": "entity"},
        "RANGE_VALUE_PAIR": {"autocomplete": False, "service": "rdbms", "class": "entity"},
    }
    _displayTypeDict = {
        "birdSummaryResults": [
            ("pdbx_reference_molecule_list", "family_prd_id", "Family ID", "%s", "str", "18px"),
            ("pdbx_reference_molecule", "prd_id", "PRD ID", "%s", "str", "18px"),
            ("pdbx_reference_molecule", "name", "Name", "%s", "str", "50px"),
            ("pdbx_reference_molecule", "class", "Class", "%s", "str", "20px"),
            ("pdbx_reference_molecule", "type", "Type", "%s", "str", "15px"),
            ("pdbx_reference_molecule", "formula", "Formula", "%s", "str", "25px"),
            ("pdbx_reference_molecule", "formula_weight", "Formula weight", "%s", "str", "10px"),
            ("pdbx_reference_molecule", "chem_comp_id", "CC ID", "%s", "str", "8px"),
        ],
        "birdSummaryResultsSequence": [
            ("pdbx_reference_molecule_list", "family_prd_id", "Family ID", "%s", "str", "18px"),
            ("pdbx_reference_molecule", "prd_id", "PRD ID", "%s", "str", "18px"),
            ("pdbx_reference_molecule", "name", "Name", "%s", "str", "50px"),
            ("pdbx_reference_molecule", "class", "Class", "%s", "str", "20px"),
            ("pdbx_reference_molecule", "type", "Type", "%s", "str", "15px"),
            ("pdbx_reference_molecule", "formula", "Formula", "%s", "str", "25px"),
            ("pdbx_reference_molecule", "chem_comp_id", "CC ID", "%s", "str", "8px"),
            ("pdbx_reference_entity_sequence", "one_letter_codes", "Sequence", "%s", "str", "50px"),
        ],
        "birdSummaryResultsSubcomponents": [
            ("pdbx_reference_molecule_list", "family_prd_id", "Family ID", "%s", "str", "18px"),
            ("pdbx_reference_molecule", "prd_id", "PRD ID", "%s", "str", "18px"),
            ("pdbx_reference_molecule", "name", "Name", "%s", "str", "50px"),
            ("pdbx_reference_molecule", "class", "Class", "%s", "str", "20px"),
            ("pdbx_reference_molecule", "type", "Type", "%s", "str", "15px"),
            ("pdbx_reference_molecule", "formula", "Formula", "%s", "str", "25px"),
            ("pdbx_reference_molecule", "chem_comp_id", "CC ID", "%s", "str", "8px"),
            ("pdbx_reference_entity_subcomponents", "seq", "Subcomponents", "%s", "str", "50px"),
        ],
        "birdSummaryResultsSequenceTlc": [
            ("pdbx_reference_molecule_list", "family_prd_id", "Family ID", "%s", "str", "18px"),
            ("pdbx_reference_molecule", "prd_id", "PRD ID", "%s", "str", "18px"),
            ("pdbx_reference_molecule", "name", "Name", "%s", "str", "50px"),
            ("pdbx_reference_molecule", "class", "Class", "%s", "str", "20px"),
            ("pdbx_reference_molecule", "type", "Type", "%s", "str", "15px"),
            ("pdbx_reference_molecule", "formula", "Formula", "%s", "str", "25px"),
            ("pdbx_reference_molecule", "chem_comp_id", "CC ID", "%s", "str", "8px"),
            ("pdbx_reference_entity_sequence_list", "three_letter_codes", "Sequence", "%s", "str", "50px"),
        ],
        "birdSummaryResultsSourceOrganism": [
            ("pdbx_reference_molecule_list", "family_prd_id", "Family ID", "%s", "str", "18px"),
            ("pdbx_reference_molecule", "prd_id", "PRD ID", "%s", "str", "18px"),
            ("pdbx_reference_molecule", "name", "Name", "%s", "str", "50px"),
            ("pdbx_reference_molecule", "class", "Class", "%s", "str", "20px"),
            ("pdbx_reference_molecule", "type", "Type", "%s", "str", "15px"),
            ("pdbx_reference_molecule", "formula", "Formula", "%s", "str", "25px"),
            ("pdbx_reference_molecule", "chem_comp_id", "CC ID", "%s", "str", "8px"),
            ("pdbx_reference_entity_src_nat", "organism_scientific", "Organism Name", "%s", "str", "50px"),
        ],
        "birdSummaryResultsSynonym": [
            ("pdbx_reference_molecule_list", "family_prd_id", "Family ID", "%s", "str", "18px"),
            ("pdbx_reference_molecule", "prd_id", "PRD ID", "%s", "str", "18px"),
            ("pdbx_reference_molecule", "name", "Name", "%s", "str", "50px"),
            ("pdbx_reference_molecule_synonyms", "ordinal", "Synonym Number", "%s", "str", "5px"),
            ("pdbx_reference_molecule_synonyms", "name", "Synonym", "%s", "str", "40px"),
            ("pdbx_reference_molecule", "class", "Class", "%s", "str", "20px"),
            ("pdbx_reference_molecule", "type", "Type", "%s", "str", "15px"),
            ("pdbx_reference_molecule", "formula", "Formula", "%s", "str", "25px"),
            ("pdbx_reference_molecule", "chem_comp_id", "CC ID", "%s", "str", "8px"),
        ],
        "OldbirdSummaryResultsInstancePublic": [
            ("cleanv1.pdbx_molecule_features", "prd_id", "PRD ID", "%s", "str", "18px"),
            ("cleanv1.pdbx_molecule_features", "Structure_ID", "PDB_ID", "%s", "str", "10px"),
            ("cleanv1.pdbx_molecule_features", "name", "Name", "%s", "str", "50px"),
            ("cleanv1.pdbx_molecule_features", "class", "Class", "%s", "str", "20px"),
            ("cleanv1.pdbx_molecule_features", "type", "Type", "%s", "str", "20px"),
            ("cleanv1.pdbx_molecule_features", "details", "Details", "%s", "str", "50px"),
        ],
        "birdSummaryResultsInstancePublic": [
            ("da_internal_combine.pdbx_molecule_features", "prd_id", "PRD ID", "%s", "str", "18px"),
            ("da_internal_combine.pdbx_molecule_features", "Structure_ID", "RCSB_ID", "%s", "str", "18px"),
            ("da_internal_combine.pdbx_molecule_features", "name", "Name", "%s", "str", "50px"),
            ("da_internal_combine.pdbx_molecule_features", "class", "Class", "%s", "str", "20px"),
            ("da_internal_combine.pdbx_molecule_features", "type", "Type", "%s", "str", "20px"),
            ("da_internal_combine.pdbx_molecule_features", "details", "Details", "%s", "str", "50px"),
            ("da_internal_combine.rcsb_status", "status_code", "Status", "%s", "str", "10px"),
        ],
        "birdSummaryResultsInstanceInternal": [
            ("da_internal_combine.pdbx_molecule_features", "prd_id", "PRD ID", "%s", "str", "18px"),
            ("da_internal_combine.pdbx_molecule_features", "Structure_ID", "RCSB_ID", "%s", "str", "18px"),
            ("da_internal_combine.pdbx_molecule_features", "name", "Name", "%s", "str", "50px"),
            ("da_internal_combine.pdbx_molecule_features", "class", "Class", "%s", "str", "20px"),
            ("da_internal_combine.pdbx_molecule_features", "type", "Type", "%s", "str", "20px"),
            ("da_internal_combine.pdbx_molecule_features", "details", "Details", "%s", "str", "50px"),
            ("da_internal_combine.rcsb_status", "status_code", "Status", "%s", "str", "10px"),
        ],
        "ccdSummaryResults": [
            ("chem_comp", "id", "ID", "%s", "str", "10px"),
            ("chem_comp", "name", "Name", "%s", "str", "50px"),
            ("chem_comp", "type", "Type", "%s", "str", "15px"),
            ("chem_comp", "formula", "Formula", "%s", "str", "25px"),
            ("chem_comp", "formula_weight", "Formula weight", "%s", "str", "10px"),
            ("chem_comp", "pdbx_synonyms", "Synonyms", "%s", "str", "20px"),
            ("chem_comp", "pdbx_subcomponent_list", "Subcomponents", "%s", "str", "40px"),
            ("chem_comp", "pdbx_release_status", "Status", "%s", "str", "10px"),
        ],
        "OldccdSummaryResultsInstanceRel": [
            ("cleanv1.chem_comp", "id", "CC ID", "%s", "str", "10px"),
            ("cleanv1.pdb_entry", "pdb_id", "PDB ID", "%s", "str", "10px"),
            ("cleanv1.pdb_entry", "Structure_ID", "DEP ID", "%s", "str", "10px"),
            ("cleanv1.pdb_entry", "method", "Method", "%s", "str", "50px"),
            ("cleanv1.pdb_entry", "title", "Title", "%s", "str", "50px"),
            ("cleanv1.pdb_entry", "date_of_RCSB_release", "Release", "%s", "str", "50px"),
            ("cleanv1.pdb_entry", "status_code", "Status", "%s", "str", "50px"),
        ],
        "ccdSummaryResultsInstanceRel": [
            ("da_internal_combine.chem_comp", "id", "CC ID", "%s", "str", "10px"),
            ("da_internal_combine.rcsb_status", "pdb_id", "PDB ID", "%s", "str", "10px"),
            ("da_internal_combine.rcsb_status", "Structure_ID", "Structure ID", "%s", "str", "10px"),
            ("da_internal_combine.rcsb_status", "exp_method", "Method", "%s", "str", "50px"),
            ("da_internal_combine.rcsb_status", "title", "Title", "%s", "str", "50px"),
            # ('da_internal_combine.rcsb_status', 'date_of_RCSB_release', 'Release', '%s', 'str', '50px'),
            ("da_internal_combine.rcsb_status", "status_code", "Status", "%s", "str", "50px"),
        ],
        "ccdSummaryResultsInstanceInternal": [
            ("da_internal_combine.chem_comp", "id", "CC ID", "%s", "str", "10px"),
            ("da_internal_combine.rcsb_status", "pdb_id", "PDB ID", "%s", "str", "10px"),
            ("da_internal_combine.rcsb_status", "Structure_ID", "Structure ID", "%s", "str", "10px"),
            ("da_internal_combine.rcsb_status", "exp_method", "Method", "%s", "str", "50px"),
            ("da_internal_combine.rcsb_status", "title", "Title", "%s", "str", "50px"),
            # ('da_internal_combine.rcsb_status', 'date_of_RCSB_release', 'Release', '%s', 'str', '50px'),
            ("da_internal_combine.rcsb_status", "status_code", "Status", "%s", "str", "50px"),
        ],
        "ccdIndexResults": [
            ("index", "ccId", "ID", "%s", "str", "10px"),
            ("index", "name", "Name", "%s", "str", "50px"),
            ("index", "type", "Type", "%s", "str", "15px"),
            ("index", "formula", "Formula", "%s", "str", "25px"),
            ("index", "formulaWeight", "Formula weight", "%s", "str", "10px"),
            ("index", "synonyms", "Synonyms", "%s", "str", "20px"),
            ("index", "subcomponentList", "Subcomponents", "%s", "str", "40px"),
            ("index", "releaseStatus", "Status", "%s", "str", "10px"),
        ],
    }

    _keyDict = {
        "pdbx_reference_molecule_family": ("family_prd_id"),
        "pdbx_reference_molecule_list": ("family_prd_id", "prd_id"),
        "pdbx_reference_molecule": ("prd_id"),
        "pdbx_reference_entity_list": ("prd_id"),
        "pdbx_reference_entity_nonpoly": ("prd_id"),
        "pdbx_reference_entity_link": ("prd_id"),
        "pdbx_reference_entity_poly_link": ("prd_id"),
        "pdbx_reference_entity_poly": ("prd_id"),
        "pdbx_reference_entity_poly_seq": ("prd_id"),
        "pdbx_reference_entity_sequence": ("prd_id"),
        "pdbx_reference_entity_sequence_list": ("prd_id"),
        "pdbx_reference_entity_src_nat": ("prd_id"),
        "pdbx_reference_entity_subcomponents": ("prd_id"),
        "pdbx_reference_molecule_details": ("family_prd_id", "prd_id"),
        "pdbx_reference_molecule_synonyms": ("family_prd_id", "prd_id"),
        "pdbx_reference_molecule_annotation": ("family_prd_id", "prd_id"),
        "pdbx_reference_molecule_features": ("family_prd_id", "prd_id"),
        "pdbx_reference_molecule_related_structures": ("family_prd_id"),
        "pdbx_prd_audit": ("prd_id"),
        "pdbx_family_prd_audit": ("family_prd_id"),
        # Bird inst
        "cleanv1.pdbx_molecule_features": ("Structure_ID"),
        "da_internal_combine.pdbx_molecule_features": ("Structure_ID"),
        "da_internal_combine.rcsb_status": ("Structure_ID"),
        # Chemical component
        "chem_comp": ("Component_ID"),
        "chem_comp_atom": ("Component_ID"),
        "chem_comp_bond": ("Component_ID"),
        "pdbx_chem_comp_audit": ("Component_ID"),
        "pdbx_chem_comp_descriptor": ("Component_ID"),
        "pdbx_chem_comp_identifier": ("Component_ID"),
        # Chemical component instances
        "cleanv1.pdb_entry": ("pdb_id"),
        "cleanv1.chem_comp": ("Structure_ID"),
        # 'da_internal_combine.rcsb_status': ('Structure_ID'),
        "da_internal_combine.chem_comp": ("Structure_ID"),
    }

    _searchTypeDict = {
        "BIRD_FAMILY_ID": {
            "queryColList": ["pdbx_reference_molecule_list.family_prd_id"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": "PRD",
            "displayType": "birdSummaryResults",
            "displayTitle": "",
        },
        "BIRD_PRD_ID": {
            "queryColList": ["pdbx_reference_molecule.prd_id"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": "PRD",
            "displayType": "birdSummaryResults",
            "displayTitle": "",
            "leftJoinTableList": ["pdbx_reference_molecule_list"],
        },
        "BIRD_NAME": {
            "queryColList": ["pdbx_reference_molecule.name"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": "PRD",
            "displayType": "birdSummaryResults",
            "displayTitle": "",
            "leftJoinTableList": ["pdbx_reference_molecule_list"],
        },
        "BIRD_SYNONYM": {
            "queryColList": ["pdbx_reference_molecule_synonyms.name"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": "PRD",
            "displayType": "birdSummaryResultsSynonym",
            "displayTitle": "",
            "leftJoinTableList": ["pdbx_reference_molecule_list"],
        },
        "BIRD_NAME_OR_SYNONYM": {
            "queryColList": ["pdbx_reference_molecule.name", "pdbx_reference_molecule_synonyms.name"],
            "logicalOp": "OR",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": "PRD",
            "displayType": "birdSummaryResultsSynonym",
            "displayTitle": "",
            "leftJoinTableList": ["pdbx_reference_molecule_list"],
        },
        "BIRD_CC_ID": {
            "queryColList": ["pdbx_reference_molecule.chem_comp_id"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": "PRD",
            "displayType": "birdSummaryResults",
            "displayTitle": "",
            "leftJoinTableList": ["pdbx_reference_molecule_list"],
        },
        "BIRD_TYPE": {
            "queryColList": ["pdbx_reference_molecule.type"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": "PRD",
            "displayType": "birdSummaryResults",
            "displayTitle": "",
            "leftJoinTableList": ["pdbx_reference_molecule_list"],
        },
        "BIRD_CLASS": {
            "queryColList": ["pdbx_reference_molecule.class"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": "PRD",
            "displayType": "birdSummaryResults",
            "displayTitle": "",
            "leftJoinTableList": ["pdbx_reference_molecule_list"],
        },
        "BIRD_FORMULA": {
            "queryColList": ["pdbx_reference_molecule.formula"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": "PRD",
            "displayType": "birdSummaryResults",
            "displayTitle": "",
            "leftJoinTableList": ["pdbx_reference_molecule_list"],
        },
        "BIRD_SEQ_ONE_LETTER_CODE": {
            "queryColList": ["pdbx_reference_entity_sequence.one_letter_codes"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": "PRD",
            "displayType": "birdSummaryResultsSequence",
            "displayTitle": "",
            "leftJoinTableList": ["pdbx_reference_molecule_list"],
        },
        "BIRD_SEQ_THREE_LETTER_CODE": {
            "queryColList": ["pdbx_reference_entity_sequence_list.three_letter_codes"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": "PRD",
            "displayType": "birdSummaryResultsSequenceTlc",
            "displayTitle": "",
            "leftJoinTableList": ["pdbx_reference_molecule_list"],
        },
        "BIRD_SOURCE_ORGANISN_NAME": {
            "queryColList": ["pdbx_reference_entity_src_nat.organism_scientific"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": "PRD",
            "displayType": "birdSummaryResultsSourceOrganism",
            "displayTitle": "",
            "leftJoinTableList": ["pdbx_reference_molecule_list"],
        },
        "BIRD_SUBCOMPONENTS": {
            "queryColList": ["pdbx_reference_entity_subcomponents.seq"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": "PRD",
            "displayType": "birdSummaryResultsSubcomponents",
            "displayTitle": "",
        },
        "BIRDINST_PRD_ID_PUBLIC": {
            "queryColList": ["da_internal_combine.pdbx_molecule_features.prd_id"],
            "logicalOp": "AND",
            "extraConditions": ' (da_internal_combine.rcsb_status.status_code = "REL") ',
            "orderByList": [
                "da_internal_combine.pdbx_molecule_features.prd_id",
                "da_internal_combine.rcsb_status.status_code",
                "da_internal_combine.pdbx_molecule_features.Structure_ID",
            ],
            "resourceId": "DA_INTERNAL_COMBINE",
            "displayType": "birdSummaryResultsInstancePublic",
            "displayTitle": "BIRD instances in public entries",
        },
        "BIRDINST_PRD_ID_INTERNAL": {
            "queryColList": ["da_internal_combine.pdbx_molecule_features.prd_id"],
            "logicalOp": "AND",
            "extraConditions": ' (da_internal_combine.rcsb_status.status_code != "REL") ',
            "orderByList": [
                "da_internal_combine.pdbx_molecule_features.prd_id",
                "da_internal_combine.rcsb_status.status_code",
                "da_internal_combine.pdbx_molecule_features.Structure_ID",
            ],
            "resourceId": "DA_INTERNAL_COMBINE",
            "displayType": "birdSummaryResultsInstanceInternal",
            "displayTitle": "BIRD instances in internal entries",
        },
        "CCD_CC_ID": {
            "queryColList": ["chem_comp.Component_id"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": "CC",
            "displayType": "ccdSummaryResults",
            "displayTitle": "",
        },
        "CCD_NAME": {
            "queryColList": ["chem_comp.name"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": "CC",
            "displayType": "ccdSummaryResults",
            "displayTitle": "",
        },
        "CCD_SYNONYM": {
            "queryColList": ["chem_comp.pdbx_synonyms"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": "CC",
            "displayType": "ccdSummaryResults",
            "displayTitle": "",
        },
        "CCD_NAME_OR_SYNONYM": {
            "queryColList": ["chem_comp.name", "chem_comp.pdbx_synonyms"],
            "logicalOp": "OR",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": "CC",
            "displayType": "ccdSummaryResults",
            "displayTitle": "",
        },
        "CCD_FORMULA": {
            "queryColList": ["chem_comp.formula"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": "CC",
            "displayType": "ccdSummaryResults",
            "displayTitle": "",
        },
        "CCD_FORMULA_WEIGHT": {
            "queryColList": ["chem_comp.formula_weight"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": "CC",
            "displayType": "ccdSummaryResults",
            "displayTitle": "",
        },
        "CCD_SUBCOMPONENTS": {
            "queryColList": ["chem_comp.pdbx_subcomponent_list"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": "CC",
            "displayType": "ccdSummaryResults",
            "displayTitle": "",
        },
        "CCDINST_CC_ID_PUBLIC": {
            "queryColList": ["da_internal_combine.chem_comp.id"],
            "logicalOp": "AND",
            "extraConditions": ' (da_internal_combine.rcsb_status.status_code = "REL") ',
            "orderByList": ["da_internal_combine.chem_comp.id", "da_internal_combine.rcsb_status.status_code", "da_internal_combine.rcsb_status.Structure_ID"],
            "resourceId": "DA_INTERNAL_COMBINE",
            "displayType": "ccdSummaryResultsInstanceRel",
            "displayTitle": "Chemical component instances in public entries",
        },
        "CCDINST_CC_ID_INTERNAL": {
            "queryColList": ["da_internal_combine.chem_comp.id"],
            "logicalOp": "AND",
            "extraConditions": ' (da_internal_combine.rcsb_status.status_code != "REL") ',
            "orderByList": ["da_internal_combine.chem_comp.id", "da_internal_combine.rcsb_status.status_code", "da_internal_combine.rcsb_status.Structure_ID"],
            "resourceId": "DA_INTERNAL_COMBINE",
            "displayType": "ccdSummaryResultsInstanceInternal",
            "displayTitle": "Chemical component instances in internal entries",
        },
        "CCDIDX_FORMULA": {
            "queryColList": ["formula"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": None,
            "displayType": "ccdIndexResults",
            "displayTitle": "",
        },
        "CCDIDX_FORMULA_BOUNDED": {
            "queryColList": ["formula"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": None,
            "displayType": "ccdIndexResults",
            "displayTitle": "",
        },
        "CCDIDX_FORMULA_SUBSET": {
            "queryColList": ["formula"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": None,
            "displayType": "ccdIndexResults",
            "displayTitle": "",
        },
        "CCDIDX_FORMULA_HEAVY_ATOM_EXACT": {
            "queryColList": ["formula"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": None,
            "displayType": "ccdIndexResults",
            "displayTitle": "",
        },
        "CCDIDX_FORMULA_EXACT": {
            "queryColList": ["formula"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": None,
            "displayType": "ccdIndexResults",
            "displayTitle": "",
        },
        "CCDIDX_FORMULA_WEIGHT_RANGE": {
            "queryColList": ["formulaWeight"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": None,
            "displayType": "ccdIndexResults",
            "displayTitle": "",
        },
        "CCDIDX_INCHI": {
            "queryColList": ["InChI"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": None,
            "displayType": "ccdIndexResults",
            "displayTitle": "",
        },
        "CCDIDX_INCHIKEY": {
            "queryColList": ["InChIKey"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": None,
            "displayType": "ccdIndexResults",
            "displayTitle": "",
        },
        "CCDIDX_INCHIKEY14": {
            "queryColList": ["InChIKey14"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": None,
            "displayType": "ccdIndexResults",
            "displayTitle": "",
        },
        "CCDIDX_SUBCOMPONENTS": {
            "queryColList": ["subcomponentList"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": None,
            "displayType": "ccdIndexResults",
            "displayTitle": "",
        },
        "CCDIDX_SUBCOMPONENT_SUBSET": {
            "queryColList": ["subcomponentList"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": None,
            "displayType": "ccdIndexResults",
            "displayTitle": "",
        },
        "CCDIDX_SMILES": {
            "queryColList": ["smilesList"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": None,
            "displayType": "ccdIndexResults",
            "displayTitle": "",
        },
        "CCDIDX_SMILES_STEREO": {
            "queryColList": ["smilesList"],
            # 'queryColList': ['smilesStereo'],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": None,
            "displayType": "ccdIndexResults",
            "displayTitle": "",
        },
        "CCDIDX_SIMILAR_NAME": {
            "queryColList": ["nameList"],
            "logicalOp": "AND",
            "extraConditions": "",
            "orderByList": [],
            "resourceId": None,
            "displayType": "ccdIndexResults",
            "displayTitle": "",
        },
    }
