"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GroupMetricRule = exports.GroupMetricRuleProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cms_generated_1 = require("./cms.generated");
Object.defineProperty(exports, "GroupMetricRuleProperty", { enumerable: true, get: function () { return cms_generated_1.RosGroupMetricRule; } });
/**
 * A ROS resource type:  `ALIYUN::CMS::GroupMetricRule`
 */
class GroupMetricRule extends ros.Resource {
    /**
     * Create a new `ALIYUN::CMS::GroupMetricRule`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosGroupMetricRule = new cms_generated_1.RosGroupMetricRule(this, id, {
            noEffectiveInterval: props.noEffectiveInterval,
            silenceTime: props.silenceTime,
            category: props.category,
            ruleId: props.ruleId,
            dimensions: props.dimensions,
            period: props.period,
            effectiveInterval: props.effectiveInterval,
            namespace: props.namespace,
            groupId: props.groupId,
            metricName: props.metricName,
            escalations: props.escalations,
            emailSubject: props.emailSubject,
            webhook: props.webhook,
            ruleName: props.ruleName,
            interval: props.interval,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosGroupMetricRule;
        this.attrRuleId = rosGroupMetricRule.attrRuleId;
    }
}
exports.GroupMetricRule = GroupMetricRule;
//# sourceMappingURL=data:application/json;base64,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