# Roadmap

The tasks in the roadmap are not in the order in which they will be added to the code.

If you would like to see some features not present in the roadmap, please feel free to add a [new GitHub issue](https://github.com/mljar/mljar-supervised/issues/new).

If you need some features, please add comments in the corresponding Github issue. It will help to prioritize what is needed.

## Near future

* [x] Add Golden Features (added in `0.6.0`)
* [x] Add Features Selection (added in `0.6.0`)
* [x] Make `AutoML` compatible with scikit-learn API (added in `0.7.0`)
* [ ] Create great docs!
* [ ] Advanced metrics for model evaluation (maybe custom metrics as well)  ([GitHub issue #73](https://github.com/mljar/mljar-supervised/issues/73))
* [ ] Add weights vector ([GitHub issue #154](https://github.com/mljar/mljar-supervised/issues/154))
* [ ] Pass class cost matrix ([GitHub issue #155](https://github.com/mljar/mljar-supervised/issues/155))
* [ ] Handle Imbalanced datasets  ([GitHub issue #157](https://github.com/mljar/mljar-supervised/issues/157))
* [ ] Add `explain()` method to compute explanations for predictions ([GitHub issue #180](https://github.com/mljar/mljar-supervised/issues/180))
* [ ] Add `monitor()` method to monitor the model in the production (outliers, drifts)  ([GitHub issue #179](https://github.com/mljar/mljar-supervised/issues/180))
* [ ] Blueprint for model  ([GitHub issue #123](https://github.com/mljar/mljar-supervised/issues/123))
* [ ] New validation strategies ([GitHub issue #160](https://github.com/mljar/mljar-supervised/issues/160), [#101](https://github.com/mljar/mljar-supervised/issues/101))

## To be discussed

* [ ] New ML task: Anomaly detection
* [ ] New ML task: Time series
* [ ] New ML task: Recommendations
* [ ] Add `deploy()` method, which deploys `AutoML` as a web service and make predictions available as REST API ([GitHub issue #54](https://github.com/mljar/mljar-supervised/issues/54))
