from pathlib import Path

import pytest

from mkdocstrings_sourcelink import MkDocGenerator

pages = {
    "Documentation": {
        "auto_generator.md": [
            "mkdocstrings_sourcelink.auto_generator.MkDocGenerator.__init__",
            "mkdocstrings_sourcelink.auto_generator.MkDocGenerator.render_to_markdown",
            "mkdocstrings_sourcelink.auto_generator.MkDocGenerator.initialize_generate",
            "mkdocstrings_sourcelink.auto_generator.MkDocGenerator.generate_docs",
            "mkdocstrings_sourcelink.auto_generator.MkDocGenerator.generate_static",
            "mkdocstrings_sourcelink.auto_generator.MkDocGenerator.generate",
        ]
    },
    "Tools": {
        "toolbox.md": [
            "mkdocstrings_sourcelink.toolbox.Utilities.insert_in_file",
            "mkdocstrings_sourcelink.toolbox.Utilities.element_to_mkdocstrings",
            "mkdocstrings_sourcelink.toolbox.Utilities.make_source_link",
            "mkdocstrings_sourcelink.toolbox.Utilities.make_title",
            "mkdocstrings_sourcelink.toolbox.Utilities.import_object",
            "mkdocstrings_sourcelink.toolbox.Utilities.return_as_Path",
        ],
    },
    "API": {
        "api.md": [
            "mkdocstrings_sourcelink.auto_generator.MkDocGenerator",
            "mkdocstrings_sourcelink.toolbox.Utilities",
        ],
    },
}
markdown_files = {"HOME": {"index.md": ["CODE_OF_CONDUCT.md"]}}
root = Path(__file__).resolve().parents[1]
_dir = root / "test" / "docs" / "src"
_tmp_dir = root / "test" / "docs" / "tmp"
_tmp_dir.mkdir(parents=True, exist_ok=True)


def test_basic_1():

    MkDocGenerator(
        _dir,
        pages,
        "https://github.com/AI2Business/mkdocstrings-sourcelink",
    ).generate
    assert len(list(_dir.glob("*.md"))) == 3


def test_basic_2():

    MkDocGenerator(
        _dir,
        pages,
        "https://github.com/AI2Business/mkdocstrings-sourcelink",
        underline_title=True,
    ).generate
    assert len(list(_dir.glob("*.md"))) == 3


def test_dict_url():

    MkDocGenerator(
        _dir,
        pages,
        {
            "mkdocstrings_sourcelink": "https://github.com/AI2Business/mkdocstrings-sourcelink"
        },
    ).generate
    assert len(list(_dir.glob("*.md"))) == 3


def test_markdown():

    MkDocGenerator(
        _dir,
        pages,
        "https://github.com/AI2Business/mkdocstrings-sourcelink",
        markdown_files=markdown_files,
    ).generate
    assert len(list(_dir.glob("*.md"))) == 4


def test_tmp():

    MkDocGenerator(
        _dir,
        pages,
        "https://github.com/AI2Business/mkdocstrings-sourcelink",
        template_dir=_tmp_dir,
    ).generate
    assert len(list(_dir.glob("*.md"))) == 3


def test_example():

    MkDocGenerator(
        _dir,
        pages,
        "https://github.com/AI2Business/mkdocstrings-sourcelink",
        example_dir=_tmp_dir,
    ).generate
    assert len(list(_dir.glob("*.md"))) == 3


def test_tmp_failed():
    with open(_tmp_dir / "template_test.md", "w") as f:
        f.write("hallo")
    with pytest.raises(Exception):
        MkDocGenerator(
            _dir,
            {
                "TemplateTest": {
                    "template_test.md": [
                        "mkdocstrings_sourcelink.auto_generator.MkDocGenerator",
                    ]
                }
            },
            "https://github.com/AI2Business/mkdocstrings-sourcelink",
            template_dir=_tmp_dir,
        ).generate


def test_tmp_run():
    with open(_tmp_dir / "template_test.md", "w") as f:
        f.write("{{autogenerated}}")
    MkDocGenerator(
        _dir,
        {
            "TemplateTest": {
                "template_test.md": [
                    "mkdocstrings_sourcelink.auto_generator.MkDocGenerator",
                ]
            }
        },
        "https://github.com/AI2Business/mkdocstrings-sourcelink",
        template_dir=_tmp_dir,
    ).generate
    assert len(list(_dir.glob("*.md"))) == 1
