#!/usr/bin/env python
# -*- encoding: utf-8 -*-

import io
import re
from glob import glob
from os.path import basename, dirname, join, splitext

from setuptools import find_packages, setup


def read(*names, **kwargs):
    with io.open(
        join(dirname(__file__), *names),
        encoding=kwargs.get('encoding', 'utf8')
    ) as fh:
        return fh.read()


setup(
    name='embfile',
    version='0.1.1',
    license='MIT license',
    description=('A package for working with files containing pre-trained word '
                 'embeddings (aka word vectors).'),
    long_description_content_type='text/x-rst',
    long_description='%s\n%s' % (
        re.compile('^.. start-badges.*^.. end-badges', re.M | re.S).sub('', read('README.rst')),
        re.sub(':[a-z]+:`~?(.*?)`', r'``\1``', read('CHANGELOG.rst'))
    ),
    author='Gianluca Gippetto',
    author_email='gianluca.gippetto@gmail.com',
    url='https://github.com/janLuke/embfile',
    packages=find_packages('src'),
    package_dir={'': 'src'},
    py_modules=[splitext(basename(path))[0] for path in glob('src/*.py')],
    include_package_data=True,
    zip_safe=False,
    classifiers=[
        # complete classifier list: http://pypi.python.org/pypi?%3Aaction=list_classifiers
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: Unix',
        'Operating System :: POSIX',
        'Operating System :: Microsoft :: Windows',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: Implementation :: CPython',
        'Topic :: Utilities',
    ],
    keywords=[
        'embeddings', 'word vectors', 'word2vec', 'nlp',
        'neural networks', 'deep learning', 'machine learning'
    ],
    install_requires=[
        'numpy',
        'tqdm',
        'overrides',
        'tabulate'
    ],
    test_require=[
        'pytest'
    ],
    extras_require={
        'dev': [
            'tox',
            'pytest',
            'pytest-cov',
            'coverage',
            'flake8',
            'mypy',
            'twine',
            'bump2version',
        ]
    },
)
