/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.util.transforms.TransformInterface;
import java.io.IOException;
import java.io.ObjectInputStream;

public class RoundNumberTransform
implements TransformInterface {
    protected int decimalPlaces;
    protected transient double multiplier;

    public RoundNumberTransform() {
        this(2);
    }

    public RoundNumberTransform(int places) {
        this.setDigitsAfterDecimal(places);
    }

    public int getDigitsAfterDecimal() {
        return this.decimalPlaces;
    }

    public void setDigitsAfterDecimal(int places) {
        this.decimalPlaces = places;
        this.multiplier = Math.pow(10.0, this.decimalPlaces);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this.multiplier = Math.pow(10.0, this.decimalPlaces);
    }

    @Override
    public Object transform(Object o) {
        if (o instanceof Number) {
            double numberValue = ((Number)o).doubleValue();
            numberValue *= this.multiplier;
            numberValue = Math.round(numberValue);
            return new Double(numberValue /= this.multiplier);
        }
        return null;
    }
}

