/*
 * Decompiled with CFR 0.152.
 */
package com.sas.iom.orb;

import com.sas.codepolicy.SASScope;
import com.sas.iom.orb.CompatibilityServant;
import com.sas.iom.orb.DelegateBase;
import com.sas.iom.orb.ORBBase;
import com.sas.iom.orb.POAImpl;
import com.sas.iom.orb.WorkException;
import com.sas.iom.orb.WorkInterface;
import java.util.Map;
import java.util.Stack;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.DynamicImplementation;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.ServantObject;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

@SASScope
public class DelegateLocal
extends DelegateBase {
    private String[] iids;
    private Servant servant;
    private byte[] oid;
    private ObjectImpl reference;
    private ServantObject servantObject;
    private Stack listenerStack;
    private POAImpl poa;

    protected DelegateLocal(ORBBase orb) {
        super((ORB)orb);
    }

    protected DelegateLocal(ORBBase orb, byte[] id, ObjectImpl ref, String iid) {
        super((ORB)orb);
        this.oid = id;
        this.reference = ref;
        this.iids = new String[]{iid};
    }

    protected DelegateLocal(ORBBase orb, byte[] id, ObjectImpl ref, Servant servant) {
        super((ORB)orb);
        this.oid = id;
        this.reference = ref;
        this.setServant(servant);
    }

    protected DelegateLocal(POAImpl poa, byte[] id, ObjectImpl ref, Servant servant) {
        this((ORBBase)poa._orb(), id, ref, servant);
        this.poa = poa;
    }

    public boolean is_a(Object obj, String repository_id) {
        if (this.iids == null) {
            return false;
        }
        for (int i = 0; i < this.iids.length; ++i) {
            if (this.iids[i].indexOf(repository_id) < 0) continue;
            return true;
        }
        return false;
    }

    public boolean non_existent(Object obj) {
        return false;
    }

    public ServantObject servant_preinvoke(Object self, String operation, Class expectedType) {
        ServantObject so = null;
        if (this.servant != null) {
            POAImpl poa = (POAImpl)this.servant._poa();
            poa.activateRequest(this);
            so = this.servantObject;
        } else if (self instanceof DynamicImplementation) {
            DynamicImplementation dynamic = (DynamicImplementation)self;
            so = new ServantObject();
            so.servant = new CompatibilityServant(dynamic);
        } else {
            String msg = "The local object reference must be activated by a POA, or it must be a DynamicImplementation.";
            throw new BAD_PARAM(msg);
        }
        if (!expectedType.isAssignableFrom(so.servant.getClass())) {
            return new ServantObject();
        }
        return so;
    }

    public void servant_postinvoke(Object self, ServantObject so) {
        if (this.servant != null && so == this.servantObject) {
            POAImpl poa = (POAImpl)this.servant._poa();
            poa.deactivateRequest();
        }
    }

    public Policy get_policy(Object obj, int policyType) {
        POAImpl p = this.getPoa(obj);
        Map<Integer, Policy> policies = p.getPolicies();
        Policy policy = policies.get(policyType);
        if (policy == null) {
            throw new BAD_PARAM();
        }
        return policy;
    }

    public Servant getServant() {
        return this.servant;
    }

    public String[] getIIDs() {
        return this.iids;
    }

    public byte[] getOID() {
        return this.oid;
    }

    public ObjectImpl getReference() {
        return this.reference;
    }

    public synchronized void pushListener(Object listener) {
        if (this.listenerStack == null) {
            this.listenerStack = new Stack();
        }
        this.listenerStack.push(listener);
    }

    public synchronized Object popListener() {
        return this.listenerStack != null ? (Object)this.listenerStack.pop() : null;
    }

    public void executeWork(WorkInterface work) throws WorkException {
        POAImpl p = this.getPoa((Object)this.reference);
        p.executeWork(work);
    }

    protected void setServant(Servant s) {
        this.servant = s;
        if (this.servant != null) {
            this.servantObject = new ServantObject();
            this.servantObject.servant = s;
            POA poa = s._poa();
            this.iids = s._all_interfaces(poa, this.oid);
        }
    }

    private POAImpl getPoa(Object obj) {
        POAImpl p = this.poa;
        if (p == null) {
            if (obj != null && obj instanceof POAImpl) {
                p = (POAImpl)obj;
            } else {
                ORBBase orb = (ORBBase)this.orb(obj);
                p = orb.getRootPOA();
            }
        }
        return p;
    }
}

