class Compose:
    """Composes several transforms together. This transform does not support torchscript.
    Please, see the note below.

    Args:
        transforms (list of ``Transform`` objects): list of transforms to compose.

    """

    def __init__(self, transforms):
        self.transforms = transforms

    def __call__(self, mem: dict):
        for t in self.transforms:
            mem = t(mem)
        return mem

    def __repr__(self):
        format_string = self.__class__.__name__ + '('
        for t in self.transforms:
            format_string += '\n'
            format_string += '    {0}'.format(t)
        format_string += '\n)'
        return format_string


class WrapDict():
    def __init__(self, key, func):
        self.key = key
        self.func = func

    def __call__(self, *args, **kwargs):
        return {self.key: self.func(*args, **kwargs)}
