# generated by fastapi-codegen:
#   filename:  processed.json
#   timestamp: 2022-12-26T23:42:09+00:00

from __future__ import annotations

from typing import Optional, Union

from fastapi import FastAPI, Header, Path

from .api_models import (
    AddUserToGroupRequest,
    ColumnUpdateRequest,
    ConnectCardConfigRequest,
    CreatePbfTokenResponse,
    MembershipRequest,
    MembershipResponse,
    NewConnectorRequestV1,
    NewDbtProjectRequest,
    NewDestinationRequest,
    NewGroupRequest,
    NewTransformationRequest,
    NewUserRequest,
    ReloadStandardConfigRequest,
    ResyncConnectorRequest,
    RunSetupTestsRequest,
    SchemaUpdateRequest,
    StandardConfigUpdateRequest,
    SyncConnectorRequest,
    TableUpdateRequest,
    TeamMembershipRequest,
    TeamRequest,
    TrustCertificateRequest,
    TrustFingerprintRequest,
    UpdateConnectorRequest,
    UpdateDestinationRequest,
    UpdateGroupRequest,
    UpdateMembershipRequest,
    UpdateTransformationRequest,
    UpdateUserRequest,
    V1CertificatesPostResponse,
    V1ConnectorsConnectorIdConnectCardPostResponse,
    V1ConnectorsConnectorIdDeleteResponse,
    V1ConnectorsConnectorIdGetResponse,
    V1ConnectorsConnectorIdPatchResponse,
    V1ConnectorsConnectorIdResyncPostResponse,
    V1ConnectorsConnectorIdSchemasGetResponse,
    V1ConnectorsConnectorIdSchemasPatchResponse,
    V1ConnectorsConnectorIdSchemasReloadPostResponse,
    V1ConnectorsConnectorIdSchemasSchemaNamePatchResponse,
    V1ConnectorsConnectorIdSchemasSchemaNameTablesTableNameColumnsColumnNamePatchResponse,
    V1ConnectorsConnectorIdSchemasSchemaNameTablesTableNamePatchResponse,
    V1ConnectorsConnectorIdSchemasSchemaTablesTableColumnsGetResponse,
    V1ConnectorsConnectorIdSchemasTablesResyncPostRequest,
    V1ConnectorsConnectorIdSchemasTablesResyncPostResponse,
    V1ConnectorsConnectorIdSyncPostResponse,
    V1ConnectorsConnectorIdTestPostResponse,
    V1ConnectorsPostResponse,
    V1DbtModelsModelIdGetResponse,
    V1DbtProjectsGetResponse,
    V1DbtProjectsPostResponse,
    V1DbtProjectsProjectIdGetResponse,
    V1DbtProjectsProjectIdModelsGetResponse,
    V1DbtProjectsProjectIdTestPostResponse,
    V1DbtProjectsProjectIdTransformationsGetResponse,
    V1DbtProjectsProjectIdTransformationsPostResponse,
    V1DbtTransformationsTransformationIdDeleteResponse,
    V1DbtTransformationsTransformationIdGetResponse,
    V1DbtTransformationsTransformationIdPatchResponse,
    V1DestinationsDestinationIdDeleteResponse,
    V1DestinationsDestinationIdGetResponse,
    V1DestinationsDestinationIdPatchResponse,
    V1DestinationsDestinationIdTestPostResponse,
    V1DestinationsPostResponse,
    V1FingerprintsPostResponse,
    V1GroupsGetResponse,
    V1GroupsGroupIdConnectorsGetResponse,
    V1GroupsGroupIdDeleteResponse,
    V1GroupsGroupIdGetResponse,
    V1GroupsGroupIdPatchResponse,
    V1GroupsGroupIdUsersGetResponse,
    V1GroupsGroupIdUsersPostResponse,
    V1GroupsGroupIdUsersUserIdDeleteResponse,
    V1GroupsPostResponse,
    V1MetadataConnectorsConnectorIdColumnsGetResponse,
    V1MetadataConnectorsConnectorIdSchemasGetResponse,
    V1MetadataConnectorsConnectorIdTablesGetResponse,
    V1MetadataNameGetResponse,
    V1MetadataNameServiceGetResponse,
    V1RolesGetResponse,
    V1TeamsGetResponse,
    V1TeamsPostResponse,
    V1TeamsTeamIdConnectorsConnectorIdDeleteResponse,
    V1TeamsTeamIdConnectorsConnectorIdGetResponse,
    V1TeamsTeamIdConnectorsConnectorIdPatchResponse,
    V1TeamsTeamIdConnectorsGetResponse,
    V1TeamsTeamIdConnectorsPostResponse,
    V1TeamsTeamIdDeleteResponse,
    V1TeamsTeamIdGetResponse,
    V1TeamsTeamIdGroupsGetResponse,
    V1TeamsTeamIdGroupsGroupIdDeleteResponse,
    V1TeamsTeamIdGroupsGroupIdGetResponse,
    V1TeamsTeamIdGroupsGroupIdPatchResponse,
    V1TeamsTeamIdGroupsPostResponse,
    V1TeamsTeamIdPatchResponse,
    V1TeamsTeamIdRoleDeleteResponse,
    V1TeamsTeamIdUsersGetResponse,
    V1TeamsTeamIdUsersPostResponse,
    V1TeamsTeamIdUsersUserIdDeleteResponse,
    V1TeamsTeamIdUsersUserIdGetResponse,
    V1TeamsTeamIdUsersUserIdPatchResponse,
    V1UsersGetResponse,
    V1UsersIdDeleteResponse,
    V1UsersPostResponse,
    V1UsersUserIdConnectorsConnectorIdDeleteResponse,
    V1UsersUserIdConnectorsConnectorIdGetResponse,
    V1UsersUserIdConnectorsConnectorIdPatchResponse,
    V1UsersUserIdConnectorsGetResponse,
    V1UsersUserIdGetResponse,
    V1UsersUserIdGroupsGetResponse,
    V1UsersUserIdGroupsGroupIdDeleteResponse,
    V1UsersUserIdGroupsGroupIdGetResponse,
    V1UsersUserIdGroupsGroupIdPatchResponse,
    V1UsersUserIdGroupsPostResponse,
    V1UsersUserIdPatchResponse,
    V1UsersUserIdRoleDeleteResponse,
    V1WebhooksGetResponse,
    WebhookRequest,
    WebhookResponse,
    WebhookTestRequest,
    WebhookTestResponse,
)

app = FastAPI(
    title="OpenAPI Definition",
    description="The OpenAPI Specification is a standard format to define the structure and syntax of REST APIs. OpenAPI documents are both machine and human-readable, which enables anyone to easily determine how each API works. [More details](https://www.openapis.org/faq)",
    version="v1",
    servers=[{"url": "https://api.fivetran.com", "variables": {}}],
)


@app.post("/v1/certificates", response_model=V1CertificatesPostResponse)
def approve_certificate(
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: TrustCertificateRequest = None,
) -> V1CertificatesPostResponse:
    """
    Approve a certificate
    """
    pass


@app.post(
    "/v1/connectors",
    response_model=None,
    responses={"201": {"model": V1ConnectorsPostResponse}},
)
def create_connector(
    accept: Optional[str] = Header("application/json;version=2", alias="Accept"),
    body: NewConnectorRequestV1 = None,
) -> Union[None, V1ConnectorsPostResponse]:
    """
    Create a Connector
    """
    pass


@app.get("/v1/connectors/{connector_id}", response_model=V1ConnectorsConnectorIdGetResponse)
def connector_details(
    connector_id: str = Path(..., alias="connectorId"),
    accept: Optional[str] = Header("application/json;version=2", alias="Accept"),
) -> V1ConnectorsConnectorIdGetResponse:
    """
    Retrieve Connector Details
    """
    pass


@app.delete(
    "/v1/connectors/{connector_id}",
    response_model=V1ConnectorsConnectorIdDeleteResponse,
)
def delete_connector(
    connector_id: str = Path(..., alias="connectorId"),
    accept: Optional[str] = Header("application/json;version=2", alias="Accept"),
) -> V1ConnectorsConnectorIdDeleteResponse:
    """
    Delete a Connector
    """
    pass


@app.patch("/v1/connectors/{connector_id}", response_model=V1ConnectorsConnectorIdPatchResponse)
def modify_connector(
    connector_id: str = Path(..., alias="connectorId"),
    accept: Optional[str] = Header("application/json;version=2", alias="Accept"),
    body: UpdateConnectorRequest = None,
) -> V1ConnectorsConnectorIdPatchResponse:
    """
    Modify a Connector
    """
    pass


@app.post(
    "/v1/connectors/{connector_id}/connect-card",
    response_model=V1ConnectorsConnectorIdConnectCardPostResponse,
)
def connect_card(
    connector_id: str = Path(..., alias="connectorId"),
    accept: Optional[str] = Header("application/json;version=2", alias="Accept"),
    body: ConnectCardConfigRequest = None,
) -> V1ConnectorsConnectorIdConnectCardPostResponse:
    """
    Connect Card
    """
    pass


@app.post(
    "/v1/connectors/{connector_id}/connect-card-token",
    response_model=CreatePbfTokenResponse,
)
def connect_card_token(
    connector_id: str = Path(..., alias="connectorId"),
    accept: Optional[str] = Header("application/json;version=2", alias="Accept"),
) -> CreatePbfTokenResponse:
    """
    Connect Card Token
    """
    pass


@app.post(
    "/v1/connectors/{connector_id}/resync",
    response_model=V1ConnectorsConnectorIdResyncPostResponse,
)
def resync_connector(
    connector_id: str = Path(..., alias="connectorId"),
    accept: Optional[str] = Header("application/json;version=2", alias="Accept"),
    body: ResyncConnectorRequest = None,
) -> V1ConnectorsConnectorIdResyncPostResponse:
    """
    Re-sync Connector Data (Historical Sync)
    """
    pass


@app.get(
    "/v1/connectors/{connector_id}/schemas",
    response_model=V1ConnectorsConnectorIdSchemasGetResponse,
)
def connector_schema_config(
    connector_id: str = Path(..., alias="connectorId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1ConnectorsConnectorIdSchemasGetResponse:
    """
    Retrieve a Connector Schema Config
    """
    pass


@app.patch(
    "/v1/connectors/{connector_id}/schemas",
    response_model=V1ConnectorsConnectorIdSchemasPatchResponse,
)
def modify_connector_schema_config(
    connector_id: str = Path(..., alias="connectorId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: StandardConfigUpdateRequest = None,
) -> V1ConnectorsConnectorIdSchemasPatchResponse:
    """
    Modify a Connector Schema Config
    """
    pass


@app.post(
    "/v1/connectors/{connector_id}/schemas/reload",
    response_model=V1ConnectorsConnectorIdSchemasReloadPostResponse,
)
def reload_connector_schema_config(
    connector_id: str = Path(..., alias="connectorId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: ReloadStandardConfigRequest = None,
) -> V1ConnectorsConnectorIdSchemasReloadPostResponse:
    """
    Reload a Connector Schema Config
    """
    pass


@app.post(
    "/v1/connectors/{connector_id}/schemas/tables/resync",
    response_model=V1ConnectorsConnectorIdSchemasTablesResyncPostResponse,
)
def resync_tables(
    connector_id: str = Path(..., alias="connectorId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: V1ConnectorsConnectorIdSchemasTablesResyncPostRequest = None,
) -> V1ConnectorsConnectorIdSchemasTablesResyncPostResponse:
    """
    Re-sync Connector Table Data
    """
    pass


@app.patch(
    "/v1/connectors/{connector_id}/schemas/{schema_name}",
    response_model=V1ConnectorsConnectorIdSchemasSchemaNamePatchResponse,
)
def modify_connector_database_schema_config(
    connector_id: str = Path(..., alias="connectorId"),
    schema_name: str = Path(..., alias="schemaName"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: SchemaUpdateRequest = None,
) -> V1ConnectorsConnectorIdSchemasSchemaNamePatchResponse:
    """
    Modify a Connector Database Schema Config
    """
    pass


@app.patch(
    "/v1/connectors/{connector_id}/schemas/{schema_name}/tables/{table_name}",
    response_model=V1ConnectorsConnectorIdSchemasSchemaNameTablesTableNamePatchResponse,
)
def modify_connector_table_config(
    connector_id: str = Path(..., alias="connectorId"),
    schema_name: str = Path(..., alias="schemaName"),
    table_name: str = Path(..., alias="tableName"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: TableUpdateRequest = None,
) -> V1ConnectorsConnectorIdSchemasSchemaNameTablesTableNamePatchResponse:
    """
    Modify a Connector Table Config
    """
    pass


@app.patch(
    "/v1/connectors/{connector_id}/schemas/{schema_name}/tables/{table_name}/columns/{column_name}",
    response_model=V1ConnectorsConnectorIdSchemasSchemaNameTablesTableNameColumnsColumnNamePatchResponse,
)
def modify_connector_column_config(
    connector_id: str = Path(..., alias="connectorId"),
    schema_name: str = Path(..., alias="schemaName"),
    table_name: str = Path(..., alias="tableName"),
    column_name: str = Path(..., alias="columnName"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: ColumnUpdateRequest = None,
) -> V1ConnectorsConnectorIdSchemasSchemaNameTablesTableNameColumnsColumnNamePatchResponse:
    """
    Modify a Connector Column Config
    """
    pass


@app.get(
    "/v1/connectors/{connector_id}/schemas/{schema}/tables/{table}/columns",
    response_model=V1ConnectorsConnectorIdSchemasSchemaTablesTableColumnsGetResponse,
)
def connector_column_config(
    connector_id: str = Path(..., alias="connectorId"),
    schema: str = ...,
    table: str = ...,
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1ConnectorsConnectorIdSchemasSchemaTablesTableColumnsGetResponse:
    """
    Retrieve Source Table Columns Config
    """
    pass


@app.post(
    "/v1/connectors/{connector_id}/sync",
    response_model=V1ConnectorsConnectorIdSyncPostResponse,
)
def sync_connector(
    connector_id: str = Path(..., alias="connectorId"),
    accept: Optional[str] = Header("application/json;version=2", alias="Accept"),
    body: SyncConnectorRequest = None,
) -> V1ConnectorsConnectorIdSyncPostResponse:
    """
    Sync Connector Data
    """
    pass


@app.post(
    "/v1/connectors/{connector_id}/test",
    response_model=V1ConnectorsConnectorIdTestPostResponse,
)
def run_setup_tests(
    connector_id: str = Path(..., alias="connectorId"),
    accept: Optional[str] = Header("application/json;version=2", alias="Accept"),
    body: RunSetupTestsRequest = None,
) -> V1ConnectorsConnectorIdTestPostResponse:
    """
    Run connector setup tests
    """
    pass


@app.get("/v1/dbt/models/{model_id}", response_model=V1DbtModelsModelIdGetResponse)
def dbt_model_details(
    model_id: str = Path(..., alias="modelId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1DbtModelsModelIdGetResponse:
    """
    Retrieve DBT Model Details
    """
    pass


@app.get("/v1/dbt/projects", response_model=V1DbtProjectsGetResponse)
def list_dbt_projects(
    group_id: Optional[str] = None,
    cursor: Optional[str] = None,
    limit: Optional[int] = None,
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1DbtProjectsGetResponse:
    """
    List All DBT Projects
    """
    pass


@app.post(
    "/v1/dbt/projects",
    response_model=None,
    responses={"201": {"model": V1DbtProjectsPostResponse}},
)
def create_dbt_project(
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: NewDbtProjectRequest = None,
) -> Union[None, V1DbtProjectsPostResponse]:
    """
    Create DBT Project
    """
    pass


@app.get("/v1/dbt/projects/{project_id}", response_model=V1DbtProjectsProjectIdGetResponse)
def dbt_project_details(
    project_id: str = Path(..., alias="projectId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1DbtProjectsProjectIdGetResponse:
    """
    Retrieve DBT Project Details
    """
    pass


@app.get(
    "/v1/dbt/projects/{project_id}/models",
    response_model=V1DbtProjectsProjectIdModelsGetResponse,
)
def list_dbt_project_models(
    project_id: str = Path(..., alias="projectId"),
    cursor: Optional[str] = None,
    limit: Optional[int] = None,
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1DbtProjectsProjectIdModelsGetResponse:
    """
    List All DBT Models
    """
    pass


@app.post(
    "/v1/dbt/projects/{project_id}/test",
    response_model=V1DbtProjectsProjectIdTestPostResponse,
)
def test_dbt_project(
    project_id: str = Path(..., alias="projectId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1DbtProjectsProjectIdTestPostResponse:
    """
    Test DBT Project
    """
    pass


@app.get(
    "/v1/dbt/projects/{project_id}/transformations",
    response_model=V1DbtProjectsProjectIdTransformationsGetResponse,
)
def list_dbt_project_transformations(
    project_id: str = Path(..., alias="projectId"),
    cursor: Optional[str] = None,
    limit: Optional[int] = None,
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1DbtProjectsProjectIdTransformationsGetResponse:
    """
    List All DBT Transformations
    """
    pass


@app.post(
    "/v1/dbt/projects/{project_id}/transformations",
    response_model=None,
    responses={"201": {"model": V1DbtProjectsProjectIdTransformationsPostResponse}},
)
def create_dbt_transformation(
    project_id: str = Path(..., alias="projectId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: NewTransformationRequest = None,
) -> Union[None, V1DbtProjectsProjectIdTransformationsPostResponse]:
    """
    Create DBT Transformation
    """
    pass


@app.get(
    "/v1/dbt/transformations/{transformation_id}",
    response_model=V1DbtTransformationsTransformationIdGetResponse,
)
def dbt_transformation_details(
    transformation_id: str = Path(..., alias="transformationId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1DbtTransformationsTransformationIdGetResponse:
    """
    Retrieve DBT Transformation Details
    """
    pass


@app.delete(
    "/v1/dbt/transformations/{transformation_id}",
    response_model=V1DbtTransformationsTransformationIdDeleteResponse,
)
def delete_dbt_transformation(
    transformation_id: str = Path(..., alias="transformationId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1DbtTransformationsTransformationIdDeleteResponse:
    """
    Delete DBT Transformation
    """
    pass


@app.patch(
    "/v1/dbt/transformations/{transformation_id}",
    response_model=V1DbtTransformationsTransformationIdPatchResponse,
)
def modify_dbt_transformation(
    transformation_id: str = Path(..., alias="transformationId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: UpdateTransformationRequest = None,
) -> V1DbtTransformationsTransformationIdPatchResponse:
    """
    Modify DBT Transformation
    """
    pass


@app.post(
    "/v1/destinations",
    response_model=None,
    responses={"201": {"model": V1DestinationsPostResponse}},
)
def create_destination(
    accept: Optional[str] = Header("application/json;version=2", alias="Accept"),
    body: NewDestinationRequest = None,
) -> Union[None, V1DestinationsPostResponse]:
    """
    Create destination
    """
    pass


@app.get(
    "/v1/destinations/{destination_id}",
    response_model=V1DestinationsDestinationIdGetResponse,
)
def destination_details(
    destination_id: str = Path(..., alias="destinationId"),
    accept: Optional[str] = Header("application/json;version=2", alias="Accept"),
) -> V1DestinationsDestinationIdGetResponse:
    """
    Retrieve Destination Details
    """
    pass


@app.delete(
    "/v1/destinations/{destination_id}",
    response_model=V1DestinationsDestinationIdDeleteResponse,
)
def delete_destination(
    destination_id: str = Path(..., alias="destinationId"),
    accept: Optional[str] = Header("application/json;version=2", alias="Accept"),
) -> V1DestinationsDestinationIdDeleteResponse:
    """
    Delete a destination
    """
    pass


@app.patch(
    "/v1/destinations/{destination_id}",
    response_model=V1DestinationsDestinationIdPatchResponse,
)
def modify_destination(
    destination_id: str = Path(..., alias="destinationId"),
    accept: Optional[str] = Header("application/json;version=2", alias="Accept"),
    body: UpdateDestinationRequest = None,
) -> V1DestinationsDestinationIdPatchResponse:
    """
    Modify a Destination
    """
    pass


@app.post(
    "/v1/destinations/{destination_id}/test",
    response_model=V1DestinationsDestinationIdTestPostResponse,
)
def run_destination_setup_tests(
    destination_id: str = Path(..., alias="destinationId"),
    accept: Optional[str] = Header("application/json;version=2", alias="Accept"),
    body: RunSetupTestsRequest = None,
) -> V1DestinationsDestinationIdTestPostResponse:
    """
    Run Destination Setup Tests
    """
    pass


@app.post("/v1/fingerprints", response_model=V1FingerprintsPostResponse)
def approve_fingerprint(
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: TrustFingerprintRequest = None,
) -> V1FingerprintsPostResponse:
    """
    Approve a fingerprint
    """
    pass


@app.get("/v1/groups", response_model=V1GroupsGetResponse)
def list_all_groups(
    cursor: Optional[str] = None,
    limit: Optional[int] = None,
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1GroupsGetResponse:
    """
    List All Groups
    """
    pass


@app.post(
    "/v1/groups",
    response_model=None,
    responses={"201": {"model": V1GroupsPostResponse}},
)
def create_group(
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: NewGroupRequest = None,
) -> Union[None, V1GroupsPostResponse]:
    """
    Create a Group
    """
    pass


@app.get("/v1/groups/{group_id}", response_model=V1GroupsGroupIdGetResponse)
def group_details(
    group_id: str = Path(..., alias="groupId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1GroupsGroupIdGetResponse:
    """
    Retrieve Group Details
    """
    pass


@app.delete("/v1/groups/{group_id}", response_model=V1GroupsGroupIdDeleteResponse)
def delete_group(
    group_id: str = Path(..., alias="groupId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1GroupsGroupIdDeleteResponse:
    """
    Delete a group
    """
    pass


@app.patch("/v1/groups/{group_id}", response_model=V1GroupsGroupIdPatchResponse)
def modify_group(
    group_id: str = Path(..., alias="groupId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: UpdateGroupRequest = None,
) -> V1GroupsGroupIdPatchResponse:
    """
    Modify a Group
    """
    pass


@app.get(
    "/v1/groups/{group_id}/connectors",
    response_model=V1GroupsGroupIdConnectorsGetResponse,
)
def list_all_connectors_in_group(
    group_id: str = Path(..., alias="groupId"),
    schema: Optional[str] = None,
    cursor: Optional[str] = None,
    limit: Optional[int] = None,
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1GroupsGroupIdConnectorsGetResponse:
    """
    List All Connectors within a Group
    """
    pass


@app.get("/v1/groups/{group_id}/users", response_model=V1GroupsGroupIdUsersGetResponse)
def list_all_users_in_group(
    group_id: str = Path(..., alias="groupId"),
    cursor: Optional[str] = None,
    limit: Optional[int] = None,
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1GroupsGroupIdUsersGetResponse:
    """
    List All Users within a Group
    """
    pass


@app.post("/v1/groups/{group_id}/users", response_model=V1GroupsGroupIdUsersPostResponse)
def add_user_to_group(
    group_id: str = Path(..., alias="groupId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: AddUserToGroupRequest = None,
) -> V1GroupsGroupIdUsersPostResponse:
    """
    Add a User to a Group
    """
    pass


@app.delete(
    "/v1/groups/{group_id}/users/{user_id}",
    response_model=V1GroupsGroupIdUsersUserIdDeleteResponse,
)
def delete_user_from_group(
    group_id: str = Path(..., alias="groupId"),
    user_id: str = Path(..., alias="userId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1GroupsGroupIdUsersUserIdDeleteResponse:
    """
    Remove a User from a Group
    """
    pass


@app.get(
    "/v1/metadata/connectors/{connector_id}/columns",
    response_model=V1MetadataConnectorsConnectorIdColumnsGetResponse,
)
def column_metadata(
    connector_id: str = Path(..., alias="connectorId"),
    cursor: Optional[str] = None,
    limit: Optional[int] = None,
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1MetadataConnectorsConnectorIdColumnsGetResponse:
    """
    Retrieve column metadata
    """
    pass


@app.get(
    "/v1/metadata/connectors/{connector_id}/schemas",
    response_model=V1MetadataConnectorsConnectorIdSchemasGetResponse,
)
def schema_metadata(
    connector_id: str = Path(..., alias="connectorId"),
    cursor: Optional[str] = None,
    limit: Optional[int] = None,
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1MetadataConnectorsConnectorIdSchemasGetResponse:
    """
    Retrieve schema metadata
    """
    pass


@app.get(
    "/v1/metadata/connectors/{connector_id}/tables",
    response_model=V1MetadataConnectorsConnectorIdTablesGetResponse,
)
def table_metadata(
    connector_id: str = Path(..., alias="connectorId"),
    cursor: Optional[str] = None,
    limit: Optional[int] = None,
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1MetadataConnectorsConnectorIdTablesGetResponse:
    """
    Retrieve table metadata
    """
    pass


@app.get("/v1/metadata/{name}", response_model=V1MetadataNameGetResponse)
def metadata_connectors(
    cursor: Optional[str] = None,
    limit: Optional[int] = None,
    accept: Optional[str] = Header("application/json;version=2", alias="Accept"),
) -> V1MetadataNameGetResponse:
    """
    Retrieve source metadata
    """
    pass


@app.get("/v1/metadata/{name}/{service}", response_model=V1MetadataNameServiceGetResponse)
def metadata_connector_config(
    service: str,
    accept: Optional[str] = Header("application/json;version=2", alias="Accept"),
) -> V1MetadataNameServiceGetResponse:
    """
    Retrieve connector configuration metadata
    """
    pass


@app.get("/v1/roles", response_model=V1RolesGetResponse)
def list_all_roles(
    cursor: Optional[str] = None,
    limit: Optional[int] = None,
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1RolesGetResponse:
    """
    List all roles
    """
    pass


@app.get("/v1/teams", response_model=V1TeamsGetResponse)
def list_all_teams(
    cursor: Optional[str] = None,
    limit: Optional[int] = None,
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1TeamsGetResponse:
    """
    List all teams
    """
    pass


@app.post("/v1/teams", response_model=None, responses={"201": {"model": V1TeamsPostResponse}})
def create_team(
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: TeamRequest = None,
) -> Union[None, V1TeamsPostResponse]:
    """
    Create a team
    """
    pass


@app.get("/v1/teams/{team_id}", response_model=V1TeamsTeamIdGetResponse)
def team_details(
    team_id: str = Path(..., alias="teamId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1TeamsTeamIdGetResponse:
    """
    Retrieve team details
    """
    pass


@app.delete("/v1/teams/{team_id}", response_model=V1TeamsTeamIdDeleteResponse)
def delete_team(
    team_id: str = Path(..., alias="teamId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1TeamsTeamIdDeleteResponse:
    """
    Delete a team
    """
    pass


@app.patch("/v1/teams/{team_id}", response_model=V1TeamsTeamIdPatchResponse)
def modify_team(
    team_id: str = Path(..., alias="teamId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: TeamRequest = None,
) -> V1TeamsTeamIdPatchResponse:
    """
    Modify a team
    """
    pass


@app.get("/v1/teams/{team_id}/connectors", response_model=V1TeamsTeamIdConnectorsGetResponse)
def get_team_memberships_in_connectors(
    team_id: str = Path(..., alias="teamId"),
    cursor: Optional[str] = None,
    limit: Optional[int] = None,
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1TeamsTeamIdConnectorsGetResponse:
    """
    List all connector memberships
    """
    pass


@app.post(
    "/v1/teams/{team_id}/connectors",
    response_model=None,
    responses={"201": {"model": V1TeamsTeamIdConnectorsPostResponse}},
)
def add_team_membership_in_connector(
    team_id: str = Path(..., alias="teamId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: MembershipRequest = None,
) -> Union[None, V1TeamsTeamIdConnectorsPostResponse]:
    """
    Add connector membership
    """
    pass


@app.get(
    "/v1/teams/{team_id}/connectors/{connector_id}",
    response_model=V1TeamsTeamIdConnectorsConnectorIdGetResponse,
)
def get_team_membership_in_connector(
    team_id: str = Path(..., alias="teamId"),
    connector_id: str = Path(..., alias="connectorId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1TeamsTeamIdConnectorsConnectorIdGetResponse:
    """
    Retrieve connector membership
    """
    pass


@app.delete(
    "/v1/teams/{team_id}/connectors/{connector_id}",
    response_model=V1TeamsTeamIdConnectorsConnectorIdDeleteResponse,
)
def delete_team_membership_in_connector(
    team_id: str = Path(..., alias="teamId"),
    connector_id: str = Path(..., alias="connectorId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1TeamsTeamIdConnectorsConnectorIdDeleteResponse:
    """
    Delete connector membership
    """
    pass


@app.patch(
    "/v1/teams/{team_id}/connectors/{connector_id}",
    response_model=V1TeamsTeamIdConnectorsConnectorIdPatchResponse,
)
def update_team_membership_in_connector(
    team_id: str = Path(..., alias="teamId"),
    connector_id: str = Path(..., alias="connectorId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: UpdateMembershipRequest = None,
) -> V1TeamsTeamIdConnectorsConnectorIdPatchResponse:
    """
    Update connector membership
    """
    pass


@app.get("/v1/teams/{team_id}/groups", response_model=V1TeamsTeamIdGroupsGetResponse)
def get_team_memberships_in_groups(
    team_id: str = Path(..., alias="teamId"),
    cursor: Optional[str] = None,
    limit: Optional[int] = None,
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1TeamsTeamIdGroupsGetResponse:
    """
    List all group memberships
    """
    pass


@app.post(
    "/v1/teams/{team_id}/groups",
    response_model=None,
    responses={"201": {"model": V1TeamsTeamIdGroupsPostResponse}},
)
def add_team_membership_in_group(
    team_id: str = Path(..., alias="teamId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: MembershipRequest = None,
) -> Union[None, V1TeamsTeamIdGroupsPostResponse]:
    """
    Add group membership
    """
    pass


@app.get(
    "/v1/teams/{team_id}/groups/{group_id}",
    response_model=V1TeamsTeamIdGroupsGroupIdGetResponse,
)
def get_team_membership_in_group(
    team_id: str = Path(..., alias="teamId"),
    group_id: str = Path(..., alias="groupId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1TeamsTeamIdGroupsGroupIdGetResponse:
    """
    Retrieve group membership
    """
    pass


@app.delete(
    "/v1/teams/{team_id}/groups/{group_id}",
    response_model=V1TeamsTeamIdGroupsGroupIdDeleteResponse,
)
def delete_team_membership_in_group(
    team_id: str = Path(..., alias="teamId"),
    group_id: str = Path(..., alias="groupId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1TeamsTeamIdGroupsGroupIdDeleteResponse:
    """
    Delete group membership
    """
    pass


@app.patch(
    "/v1/teams/{team_id}/groups/{group_id}",
    response_model=V1TeamsTeamIdGroupsGroupIdPatchResponse,
)
def update_team_membership_in_group(
    team_id: str = Path(..., alias="teamId"),
    group_id: str = Path(..., alias="groupId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: UpdateMembershipRequest = None,
) -> V1TeamsTeamIdGroupsGroupIdPatchResponse:
    """
    Update group membership
    """
    pass


@app.delete("/v1/teams/{team_id}/role", response_model=V1TeamsTeamIdRoleDeleteResponse)
def delete_team_membership_in_account(
    team_id: str = Path(..., alias="teamId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1TeamsTeamIdRoleDeleteResponse:
    """
    Delete team role in account
    """
    pass


@app.get("/v1/teams/{team_id}/users", response_model=V1TeamsTeamIdUsersGetResponse)
def list_users_in_team(
    team_id: str = Path(..., alias="teamId"),
    cursor: Optional[str] = None,
    limit: Optional[int] = None,
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1TeamsTeamIdUsersGetResponse:
    """
    List all user memberships
    """
    pass


@app.post(
    "/v1/teams/{team_id}/users",
    response_model=None,
    responses={"201": {"model": V1TeamsTeamIdUsersPostResponse}},
)
def add_user_to_team(
    team_id: str = Path(..., alias="teamId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: TeamMembershipRequest = None,
) -> Union[None, V1TeamsTeamIdUsersPostResponse]:
    """
    Add a user to a team
    """
    pass


@app.get(
    "/v1/teams/{team_id}/users/{user_id}",
    response_model=V1TeamsTeamIdUsersUserIdGetResponse,
)
def get_user_in_team(
    team_id: str = Path(..., alias="teamId"),
    user_id: str = Path(..., alias="userId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1TeamsTeamIdUsersUserIdGetResponse:
    """
    Retrieve user membership in a team
    """
    pass


@app.delete(
    "/v1/teams/{team_id}/users/{user_id}",
    response_model=V1TeamsTeamIdUsersUserIdDeleteResponse,
)
def delete_user_from_team(
    team_id: str = Path(..., alias="teamId"),
    user_id: str = Path(..., alias="userId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1TeamsTeamIdUsersUserIdDeleteResponse:
    """
    Delete a user from a team
    """
    pass


@app.patch(
    "/v1/teams/{team_id}/users/{user_id}",
    response_model=V1TeamsTeamIdUsersUserIdPatchResponse,
)
def update_user_membership(
    team_id: str = Path(..., alias="teamId"),
    user_id: str = Path(..., alias="userId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: UpdateMembershipRequest = None,
) -> V1TeamsTeamIdUsersUserIdPatchResponse:
    """
    Modify a user membership
    """
    pass


@app.get("/v1/users", response_model=V1UsersGetResponse)
def list_all_users(
    cursor: Optional[str] = None,
    limit: Optional[int] = None,
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1UsersGetResponse:
    """
    List All Users
    """
    pass


@app.post("/v1/users", response_model=None, responses={"201": {"model": V1UsersPostResponse}})
def create_user(
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: NewUserRequest = None,
) -> Union[None, V1UsersPostResponse]:
    """
    Invite a User
    """
    pass


@app.delete("/v1/users/{id}", response_model=V1UsersIdDeleteResponse)
def delete_user(id: str, accept: Optional[str] = Header("application/json", alias="Accept")) -> V1UsersIdDeleteResponse:
    """
    Delete a user
    """
    pass


@app.get("/v1/users/{user_id}", response_model=V1UsersUserIdGetResponse)
def user_details(
    user_id: str = Path(..., alias="userId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1UsersUserIdGetResponse:
    """
    Retrieve User Details
    """
    pass


@app.patch("/v1/users/{user_id}", response_model=V1UsersUserIdPatchResponse)
def modify_user(
    user_id: str = Path(..., alias="userId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: UpdateUserRequest = None,
) -> V1UsersUserIdPatchResponse:
    """
    Modify a User
    """
    pass


@app.get("/v1/users/{user_id}/connectors", response_model=V1UsersUserIdConnectorsGetResponse)
def get_user_memberships_in_connectors(
    user_id: str = Path(..., alias="userId"),
    cursor: Optional[str] = None,
    limit: Optional[int] = None,
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1UsersUserIdConnectorsGetResponse:
    """
    List all connector memberships
    """
    pass


@app.post(
    "/v1/users/{user_id}/connectors",
    response_model=None,
    responses={"201": {"model": MembershipResponse}},
)
def add_user_membership_in_connector(
    user_id: str = Path(..., alias="userId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: MembershipRequest = None,
) -> Union[None, MembershipResponse]:
    """
    Add connector membership
    """
    pass


@app.get(
    "/v1/users/{user_id}/connectors/{connector_id}",
    response_model=V1UsersUserIdConnectorsConnectorIdGetResponse,
)
def get_user_membership_in_connector(
    user_id: str = Path(..., alias="userId"),
    connector_id: str = Path(..., alias="connectorId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1UsersUserIdConnectorsConnectorIdGetResponse:
    """
    Retrieve connector membership
    """
    pass


@app.delete(
    "/v1/users/{user_id}/connectors/{connector_id}",
    response_model=V1UsersUserIdConnectorsConnectorIdDeleteResponse,
)
def delete_user_membership_in_connector(
    user_id: str = Path(..., alias="userId"),
    connector_id: str = Path(..., alias="connectorId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1UsersUserIdConnectorsConnectorIdDeleteResponse:
    """
    Delete connector membership
    """
    pass


@app.patch(
    "/v1/users/{user_id}/connectors/{connector_id}",
    response_model=V1UsersUserIdConnectorsConnectorIdPatchResponse,
)
def update_user_membership_in_connector(
    user_id: str = Path(..., alias="userId"),
    connector_id: str = Path(..., alias="connectorId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: UpdateMembershipRequest = None,
) -> V1UsersUserIdConnectorsConnectorIdPatchResponse:
    """
    Update connector membership
    """
    pass


@app.get("/v1/users/{user_id}/groups", response_model=V1UsersUserIdGroupsGetResponse)
def get_user_memberships_in_groups(
    user_id: str = Path(..., alias="userId"),
    cursor: Optional[str] = None,
    limit: Optional[int] = None,
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1UsersUserIdGroupsGetResponse:
    """
    List all group memberships
    """
    pass


@app.post(
    "/v1/users/{user_id}/groups",
    response_model=None,
    responses={"201": {"model": V1UsersUserIdGroupsPostResponse}},
)
def add_user_membership_in_group(
    user_id: str = Path(..., alias="userId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: MembershipRequest = None,
) -> Union[None, V1UsersUserIdGroupsPostResponse]:
    """
    Add group membership
    """
    pass


@app.get(
    "/v1/users/{user_id}/groups/{group_id}",
    response_model=V1UsersUserIdGroupsGroupIdGetResponse,
)
def get_user_membership_in_group(
    user_id: str = Path(..., alias="userId"),
    group_id: str = Path(..., alias="groupId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1UsersUserIdGroupsGroupIdGetResponse:
    """
    Retrieve group membership
    """
    pass


@app.delete(
    "/v1/users/{user_id}/groups/{group_id}",
    response_model=V1UsersUserIdGroupsGroupIdDeleteResponse,
)
def delete_user_membership_in_group(
    user_id: str = Path(..., alias="userId"),
    group_id: str = Path(..., alias="groupId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1UsersUserIdGroupsGroupIdDeleteResponse:
    """
    Delete group membership
    """
    pass


@app.patch(
    "/v1/users/{user_id}/groups/{group_id}",
    response_model=V1UsersUserIdGroupsGroupIdPatchResponse,
)
def update_user_membership_in_group(
    user_id: str = Path(..., alias="userId"),
    group_id: str = Path(..., alias="groupId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: UpdateMembershipRequest = None,
) -> V1UsersUserIdGroupsGroupIdPatchResponse:
    """
    Update group membership
    """
    pass


@app.delete("/v1/users/{user_id}/role", response_model=V1UsersUserIdRoleDeleteResponse)
def delete_user_membership_in_account(
    user_id: str = Path(..., alias="userId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1UsersUserIdRoleDeleteResponse:
    """
    Delete user role in account
    """
    pass


@app.get("/v1/webhooks", response_model=V1WebhooksGetResponse)
def list_all_webhooks(
    cursor: Optional[str] = None,
    limit: Optional[int] = None,
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> V1WebhooksGetResponse:
    """
    Retrieve the list of webhooks
    """
    pass


@app.post("/v1/webhooks/account", response_model=WebhookResponse)
def create_account_webhook(
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: WebhookRequest = None,
) -> WebhookResponse:
    """
    Create account webhook
    """
    pass


@app.post("/v1/webhooks/group/{group_id}", response_model=WebhookResponse)
def create_group_webhook(
    group_id: str = Path(..., alias="groupId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: WebhookRequest = None,
) -> WebhookResponse:
    """
    Create group webhook
    """
    pass


@app.get("/v1/webhooks/{webhook_id}", response_model=WebhookResponse)
def webhook_details(
    webhook_id: str = Path(..., alias="webhookId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> WebhookResponse:
    """
    Retrieve webhook details
    """
    pass


@app.delete("/v1/webhooks/{webhook_id}", response_model=None, responses={"204": {"model": str}})
def delete_webhook(
    webhook_id: str = Path(..., alias="webhookId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
) -> Union[None, str]:
    """
    Delete webhook
    """
    pass


@app.patch("/v1/webhooks/{webhook_id}", response_model=WebhookResponse)
def modify_webhook(
    webhook_id: str = Path(..., alias="webhookId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: WebhookRequest = None,
) -> WebhookResponse:
    """
    Update webhook
    """
    pass


@app.post("/v1/webhooks/{webhook_id}/test", response_model=WebhookTestResponse)
def test_webhook(
    webhook_id: str = Path(..., alias="webhookId"),
    accept: Optional[str] = Header("application/json", alias="Accept"),
    body: WebhookTestRequest = None,
) -> WebhookTestResponse:
    """
    Test webhook
    """
    pass
