import tkinter
import os.path
import sys


def event(evt, id, icon, x, y):
    if evt == "WM_RBUTTONDOWN":
        menu = tkinter.Menu(tearoff=False)
        menu.add_command(label="Quit", command=root.quit)
        menu.tk_popup(x, y)


root = tkinter.Tk()
root.tk.call('package', 'require', 'Winico')  # 导入Winico
icon = root.tk.call('winico', 'createfrom', os.path.split(sys.executable)[0] + "\\tcl\\pkg\\tkchat.ico")  # 设置图标
root.tk.call('winico', 'taskbar', "add", icon,
             '-callback', (root.register(event), '%m', '%i', root, '%x', '%y'),  # 设置托盘事件
             '-pos', 0,
             '-text', "Winico")  # 设置托盘提示文本
root.mainloop()