# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['InputsTcpRaw']


class InputsTcpRaw(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[pulumi.InputType['InputsTcpRawAclArgs']]] = None,
                 connection_host: Optional[pulumi.Input[str]] = None,
                 disabled: Optional[pulumi.Input[bool]] = None,
                 host: Optional[pulumi.Input[str]] = None,
                 index: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 queue: Optional[pulumi.Input[str]] = None,
                 raw_tcp_done_timeout: Optional[pulumi.Input[int]] = None,
                 restrict_to_host: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 sourcetype: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## # Resource: InputsTcpRaw

        Create or update raw TCP input information for managing raw tcp inputs from forwarders.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_splunk as splunk

        tcp_raw = splunk.InputsTcpRaw("tcpRaw",
            disabled=False,
            index="main",
            queue="indexQueue",
            source="new",
            sourcetype="new")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InputsTcpRawAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[str] connection_host: Valid values: (ip | dns | none)
               Set the host for the remote server that is sending data.
               ip sets the host to the IP address of the remote server sending data.
               dns sets the host to the reverse DNS entry for the IP address of the remote server sending data.
               none leaves the host as specified in inputs.conf, which is typically the Splunk system hostname.
               Default value is dns.
        :param pulumi.Input[bool] disabled: Indicates if input is disabled.
        :param pulumi.Input[str] host: Host from which the indexer gets data.
        :param pulumi.Input[str] index: Index to store generated events. Defaults to default.
        :param pulumi.Input[str] name: The input port which receives raw data.
        :param pulumi.Input[str] queue: Valid values: (parsingQueue | indexQueue)
               Specifies where the input processor should deposit the events it reads. Defaults to parsingQueue.
               Set queue to parsingQueue to apply props.conf and other parsing rules to your data. For more information about props.conf and rules for timestamping and linebreaking, refer to props.conf and the online documentation at "Monitor files and directories with inputs.conf"
               Set queue to indexQueue to send your data directly into the index.
        :param pulumi.Input[int] raw_tcp_done_timeout: Specifies in seconds the timeout value for adding a Done-key. Default value is 10 seconds.
               If a connection over the port specified by name remains idle after receiving data for specified number of seconds, it adds a Done-key. This implies the last event is completely received.
        :param pulumi.Input[str] restrict_to_host: Allows for restricting this input to only accept data from the host specified here.
        :param pulumi.Input[str] source: Sets the source key/field for events from this input. Defaults to the input file path.
               Sets the source key initial value. The key is used during parsing/indexing, in particular to set the source field during indexing. It is also the source field used at search time. As a convenience, the chosen string is prepended with 'source::'.
        :param pulumi.Input[str] sourcetype: Set the source type for events from this input.
               "sourcetype=" is automatically prepended to <string>.
               Defaults to audittrail (if signedaudit=true) or fschange (if signedaudit=false).
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['acl'] = acl
            __props__['connection_host'] = connection_host
            __props__['disabled'] = disabled
            __props__['host'] = host
            __props__['index'] = index
            __props__['name'] = name
            __props__['queue'] = queue
            __props__['raw_tcp_done_timeout'] = raw_tcp_done_timeout
            __props__['restrict_to_host'] = restrict_to_host
            __props__['source'] = source
            __props__['sourcetype'] = sourcetype
        super(InputsTcpRaw, __self__).__init__(
            'splunk:index/inputsTcpRaw:InputsTcpRaw',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[pulumi.InputType['InputsTcpRawAclArgs']]] = None,
            connection_host: Optional[pulumi.Input[str]] = None,
            disabled: Optional[pulumi.Input[bool]] = None,
            host: Optional[pulumi.Input[str]] = None,
            index: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            queue: Optional[pulumi.Input[str]] = None,
            raw_tcp_done_timeout: Optional[pulumi.Input[int]] = None,
            restrict_to_host: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[str]] = None,
            sourcetype: Optional[pulumi.Input[str]] = None) -> 'InputsTcpRaw':
        """
        Get an existing InputsTcpRaw resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InputsTcpRawAclArgs']] acl: The app/user context that is the namespace for the resource
        :param pulumi.Input[str] connection_host: Valid values: (ip | dns | none)
               Set the host for the remote server that is sending data.
               ip sets the host to the IP address of the remote server sending data.
               dns sets the host to the reverse DNS entry for the IP address of the remote server sending data.
               none leaves the host as specified in inputs.conf, which is typically the Splunk system hostname.
               Default value is dns.
        :param pulumi.Input[bool] disabled: Indicates if input is disabled.
        :param pulumi.Input[str] host: Host from which the indexer gets data.
        :param pulumi.Input[str] index: Index to store generated events. Defaults to default.
        :param pulumi.Input[str] name: The input port which receives raw data.
        :param pulumi.Input[str] queue: Valid values: (parsingQueue | indexQueue)
               Specifies where the input processor should deposit the events it reads. Defaults to parsingQueue.
               Set queue to parsingQueue to apply props.conf and other parsing rules to your data. For more information about props.conf and rules for timestamping and linebreaking, refer to props.conf and the online documentation at "Monitor files and directories with inputs.conf"
               Set queue to indexQueue to send your data directly into the index.
        :param pulumi.Input[int] raw_tcp_done_timeout: Specifies in seconds the timeout value for adding a Done-key. Default value is 10 seconds.
               If a connection over the port specified by name remains idle after receiving data for specified number of seconds, it adds a Done-key. This implies the last event is completely received.
        :param pulumi.Input[str] restrict_to_host: Allows for restricting this input to only accept data from the host specified here.
        :param pulumi.Input[str] source: Sets the source key/field for events from this input. Defaults to the input file path.
               Sets the source key initial value. The key is used during parsing/indexing, in particular to set the source field during indexing. It is also the source field used at search time. As a convenience, the chosen string is prepended with 'source::'.
        :param pulumi.Input[str] sourcetype: Set the source type for events from this input.
               "sourcetype=" is automatically prepended to <string>.
               Defaults to audittrail (if signedaudit=true) or fschange (if signedaudit=false).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["acl"] = acl
        __props__["connection_host"] = connection_host
        __props__["disabled"] = disabled
        __props__["host"] = host
        __props__["index"] = index
        __props__["name"] = name
        __props__["queue"] = queue
        __props__["raw_tcp_done_timeout"] = raw_tcp_done_timeout
        __props__["restrict_to_host"] = restrict_to_host
        __props__["source"] = source
        __props__["sourcetype"] = sourcetype
        return InputsTcpRaw(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output['outputs.InputsTcpRawAcl']:
        """
        The app/user context that is the namespace for the resource
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter(name="connectionHost")
    def connection_host(self) -> pulumi.Output[str]:
        """
        Valid values: (ip | dns | none)
        Set the host for the remote server that is sending data.
        ip sets the host to the IP address of the remote server sending data.
        dns sets the host to the reverse DNS entry for the IP address of the remote server sending data.
        none leaves the host as specified in inputs.conf, which is typically the Splunk system hostname.
        Default value is dns.
        """
        return pulumi.get(self, "connection_host")

    @property
    @pulumi.getter
    def disabled(self) -> pulumi.Output[bool]:
        """
        Indicates if input is disabled.
        """
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[str]:
        """
        Host from which the indexer gets data.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def index(self) -> pulumi.Output[str]:
        """
        Index to store generated events. Defaults to default.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The input port which receives raw data.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def queue(self) -> pulumi.Output[str]:
        """
        Valid values: (parsingQueue | indexQueue)
        Specifies where the input processor should deposit the events it reads. Defaults to parsingQueue.
        Set queue to parsingQueue to apply props.conf and other parsing rules to your data. For more information about props.conf and rules for timestamping and linebreaking, refer to props.conf and the online documentation at "Monitor files and directories with inputs.conf"
        Set queue to indexQueue to send your data directly into the index.
        """
        return pulumi.get(self, "queue")

    @property
    @pulumi.getter(name="rawTcpDoneTimeout")
    def raw_tcp_done_timeout(self) -> pulumi.Output[int]:
        """
        Specifies in seconds the timeout value for adding a Done-key. Default value is 10 seconds.
        If a connection over the port specified by name remains idle after receiving data for specified number of seconds, it adds a Done-key. This implies the last event is completely received.
        """
        return pulumi.get(self, "raw_tcp_done_timeout")

    @property
    @pulumi.getter(name="restrictToHost")
    def restrict_to_host(self) -> pulumi.Output[str]:
        """
        Allows for restricting this input to only accept data from the host specified here.
        """
        return pulumi.get(self, "restrict_to_host")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[str]:
        """
        Sets the source key/field for events from this input. Defaults to the input file path.
        Sets the source key initial value. The key is used during parsing/indexing, in particular to set the source field during indexing. It is also the source field used at search time. As a convenience, the chosen string is prepended with 'source::'.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def sourcetype(self) -> pulumi.Output[str]:
        """
        Set the source type for events from this input.
        "sourcetype=" is automatically prepended to <string>.
        Defaults to audittrail (if signedaudit=true) or fschange (if signedaudit=false).
        """
        return pulumi.get(self, "sourcetype")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

