# -*- coding: utf-8 -*-

"""
firstlanguageapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import os
from firstlanguage_python.utilities.schema_validator_wrapper import SchemaValidatorWrapper
from jsonschema import ValidationError
from firstlanguage_python.api_helper import APIHelper


class Input5(object):

    """Implementation of the 'Input5' model.

    TODO: type model description here.

    Attributes:
        question (string): Question to be answered from the context given.
            Only One question can be asked at a time. Special characters will
            not be stripped.
        lang (string): Allowed language code. Refer Allowed languages
            section.
        context (string): Sentence or a paragraph. Special characters will not
            be stripped.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "question": 'question',
        "lang": 'lang',
        "context": 'context'
    }

    def __init__(self,
                 question=None,
                 lang=None,
                 context=None):
        """Constructor for the Input5 class"""

        # Initialize members of the class
        self.question = question
        self.lang = lang
        self.context = context

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        question = dictionary.get('question')
        lang = dictionary.get('lang')
        context = dictionary.get('context')

        # Return an object of this model
        return cls(question,
                   lang,
                   context)

    @classmethod
    def validate(cls, val):
        """Validates value against class schema

        Args:
            val: the value to be validated

        Returns:
            boolean : if value is valid against schema.

        """
        return SchemaValidatorWrapper.getValidator(APIHelper.get_schema_path(os.path.abspath(__file__))).is_valid(val)
