# -*- coding: utf-8 -*-

"""
firstlanguage

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from firstlanguage_python.api_helper import APIHelper
from firstlanguage_python.configuration import Server
from firstlanguage_python.controllers.base_controller import BaseController 
from firstlanguage_python.http.auth.custom_header_auth import CustomHeaderAuth
from firstlanguage_python.models.responseclassify import Responseclassify
from firstlanguage_python.models.api_qa_response import ApiQaResponse
from firstlanguage_python.models.api_ner_response import ApiNerResponse
from firstlanguage_python.models.api_summary_response import ApiSummaryResponse
from firstlanguage_python.models.api_translate_response import ApiTranslateResponse
from firstlanguage_python.exceptions.errors_exception import ErrorsException
from firstlanguage_python.exceptions.api_classify_426_error_exception import ApiClassify426ErrorException
from firstlanguage_python.exceptions.api_exception import APIException
from firstlanguage_python.exceptions.m_426_error_exception import M426ErrorException


class AdvancedAPIsController(BaseController):

    """A Controller to access Endpoints in the firstlanguage API."""

    def __init__(self, config, call_back=None):
        super(AdvancedAPIsController, self).__init__(config, call_back)

    def get_classification(self,
                           body):
        """Does a POST request to /api/classify.

        # Text Classification  : Defintion and it's usage
        A text classifier identifies the categories of the text given as
        input. Classifying the texts is one of the powerful preprocessing
        technique in topic identification and sentiment classification
        (product reviews, movie reviews etc)and indexing the texts while
        building a search system.
        # Languages covered:
        | Languages  | ISO Code |
        |------------|----------|
        | Arabic     | ar       |
        | Bulgarian  | bg       |
        | Chinese    | zh       |
        | English    | en       |
        | French     | fr       |
        | German     | de       |
        | Greek      | el       |
        | Hindi      | hi       |
        | Russian    | ru       |
        | Spanish    | es       |
        | Swahili    | sw       |
        | Thai       | th       |
        | Turkish    | tr       |
        | Urdu       | ur       |
        | Vietnamese | vi       |

        Args:
            body (object): Add a JSON Input as per the schema defined below

        Returns:
            Responseclassify: Response from the API. Classifies labels.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api/classify'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        CustomHeaderAuth.apply(self.config, _request)
        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise ErrorsException('Error output', _response)
        elif _response.status_code == 426:
            raise ApiClassify426ErrorException('Please use HTTPS protocol', _response)
        elif _response.status_code == 429:
            raise APIException('Too Many Requests', _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, Responseclassify.from_dictionary)

        return decoded

    def get_qa(self,
               body=None):
        """Does a POST request to /api/qa.

        # QA : Defintion and it's usage
        A Question Answering System retrieves the answer relevant to the
        question given by the user. A question answering system can be used
        for building a text based chatbots, search engines etc. Our question
        answering system  is mutilingual and supports 100 + languages. Please
        use ISO 639-2 2 digit language code  to get results. For example, use
        'en' for English, 'ta' for Tamil, 'hi' for Hindi, 'fr' for French
        etc.
        For ISO code reference, please check the link
        https://www.loc.gov/standards/iso639-2/php/code_list.php

        Args:
            body (object, optional): Add a JSON Input as per the schema
                defined below

        Returns:
            ApiQaResponse: Response from the API. Answer for the question
                posted.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api/qa'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        CustomHeaderAuth.apply(self.config, _request)
        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise ErrorsException('Bad Request', _response)
        elif _response.status_code == 426:
            raise M426ErrorException('Please use HTTPS protocol', _response)
        elif _response.status_code == 429:
            raise APIException('Too Many Requests', _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, ApiQaResponse.from_dictionary)

        return decoded

    def get_ner(self,
                body=None):
        """Does a POST request to /api/ner.

        # Named Entity Recognition : Defintion and it's usage
        Named Entity Recognitiion  (NER) is extracting the specific Nouns such
        as, Person Names, Location names, Organization Names, Currency ,
        Dates. It is a classification task. NER can be used as a sub-task in
        applications such as Search Systems, Chatbots, Question Answering
        systems, Text Summarization etc. 
        # Languages covered:
        | Languages          | ISO Code |
        |--------------------|----------|
        | Arabic             | ar       |
        | Chinese            | zh       |
        | Dutch              | nl       |
        | English            | en       |
        | French             | fr       |
        | German             | de       |
        | Italian            | it       |
        | Latvian            | lv       |
        | Portuguese         | pt       |
        | Spanish            | es       |
        For other languages we cannot guarantee results but you can try with
        ISO code. 
        For ISO code reference, please check the link
        https://www.loc.gov/standards/iso639-2/php/code_list.php

        Args:
            body (object, optional): Add a JSON Input as per the schema
                defined below

        Returns:
            list of ApiNerResponse: Response from the API. Array of Named
                Entites marked from the input given.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api/ner'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        CustomHeaderAuth.apply(self.config, _request)
        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise ErrorsException('Bad Request', _response)
        elif _response.status_code == 426:
            raise M426ErrorException('Please use HTTPS protocol', _response)
        elif _response.status_code == 429:
            raise APIException('Too Many Requests', _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, ApiNerResponse.from_dictionary)

        return decoded

    def get_summary(self,
                    body=None):
        """Does a POST request to /api/summary.

        # Summarization : Defintion and it's usage
        Summarization generates a crisp content of the large input text which
        is highly coherent. 
        | Languages               | ISO Code |
        |-------------------------|----------|
        | Amharic                 | am       |
        | Arabic                  |  ar      |
        | Azerbaijani             |  az      |
        | Bengali                 |  bn      |
        | Burmese                 |  my      |
        | Chinese                 |  zh      |
        | English                 |  en      |
        | French                  |  fr      |
        | Gaelic; Scottish Gaelic | gd       |
        | Gujarati                |  gu      |
        | Hausa                   |  ha      |
        | Hindi                   |  hi      |
        | Igbo                    |  ig      |
        | Indonesian              |  id      |
        | Japanese                |  ja      |
        | Kirghiz; Kyrgyz         | ky       |
        | Korean                  |  ko      |
        | Marathi                 |  mr      |
        | Nepali                  |  ne      |
        | Oromo                   | om       |
        | Persian                 | fa       |
        | Portuguese              |  pt      |
        | Punjabi                 |  pa      |
        | Pushto; Pashto          | ps       |
        | Rundi                   | rn       |
        | Russian                 | ru       |
        | Serbian                 |  sr      |
        | Sinhala; Sinhalese      |  si      |
        | Somali                  |  so      |
        | Spanish; Castilian      |  es      |
        | Swahili                 |  sw      |
        | Tamil                   |  ta      |
        | Telugu                  |  te      |
        | Thai                    |  th      |
        | Tigrinya                |  ti      |
        | Turkish                 |  tr      |
        | Ukrainian               |  uk      |
        | Urdu                    |  ur      |
        | Uzbek                   |  uz      |
        | Vietnamese              |  vi      |
        | Welsh                   |  cy      |
        | Yoruba                  |  yo      |

        Args:
            body (object, optional): Add a JSON Input as per the schema
                defined below

        Returns:
            ApiSummaryResponse: Response from the API. JSON Object with
                summary of the text given

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api/summary'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        CustomHeaderAuth.apply(self.config, _request)
        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise ErrorsException('Bad Request', _response)
        elif _response.status_code == 426:
            raise M426ErrorException('Please use HTTPS protocol', _response)
        elif _response.status_code == 429:
            raise APIException('Too Many Requests', _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, ApiSummaryResponse.from_dictionary)

        return decoded

    def get_translate(self,
                      body=None):
        """Does a POST request to /api/translate.

        # Translation : Defintion and it's usage
        Machine Translation is translating the text automatically from  one
        language to another langauge.
        # Languages covered:
        | Languages                             | ISO Code   |
        |---------------------------------------|------------|
        |  Abkhazian                            |   ab       |
        |  Afrikaans                            |   af       |
        |  Amharic                              |   am       |
        |  Bashkir                              |   ba       |
        |  Catalan; Valencian                   |   ca       |
        |  Chechen                              |   ce       |
        |  Corsican                             |   co       |
        |  Chuvash                              |   cv       |
        |  Ewe                                  |   ee       |
        |  English                              |   en       |
        |  Basque                               |   eu       |
        |  Fijian                               |   fj       |
        |  French                               |   fr       |
        |  Galician                             |   gl       |
        |  Gujarati                             |   gu       |
        |  Manx                                 |   gv       |
        |  Hebrew                               |   he       |
        |  Haitian; Haitian Creole              |   ht       |
        |  Armenian                             |   hy       |
        |  Indonesian                           |   id       |
        |  Igbo                                 |   ig       |
        |  Icelandic                            |   is       |
        |  Japanese                             |   ja       |
        |  Kalaallisut; Greenlandic             |   kl       |
        |  Ganda                                |   lg       |
        |  Lingala                              |   ln       |
        |  Malagasy                             |   mg       |
        |  Marshallese                          |   mh       |
        |  Macedonian                           |   mk       |
        |  Mongolian                            |   mn       |
        |  Nauru                                |   na       |
        |  Bokmål, Norwegian; Norwegian Bokmål  |   nb       |
        |  Chichewa; Chewa; Nyanja              |   ny       |
        |  Ossetian; Ossetic                    |   os       |
        |  Pushto; Pashto                       |   ps       |
        |  Romansh                              |   rm       |
        |  Rundi                                |   rn       |
        |  Sango                                |   sg       |
        |  Samoan                               |   sm       |
        |  Shona                                |   sn       |
        |  Somali                               |   so       |
        |  Albanian                             |   sq       |
        |  Tamil                                |   ta       |
        |  Tigrinya                             |   ti       |
        |  Turkmen                              |   tk       |
        |  Tonga                                |   to       |
        |  Turkish                              |   tr       |
        |  Tsonga                               |   ts       |
        |  Tatar                                |   tt       |
        |  Tahitian                             |   ty       |
        |  Ukrainian                            |   uk       |
        |  Vietnamese                           |   vi       |
        |  Walloon                              |   wa       |
        |  Xhosa                                |   xh       |
        |  Yoruba                               |   yo       |
        |  Zulu                                 |   zu       |

        Args:
            body (object, optional): Add a JSON Input as per the schema
                defined below

        Returns:
            ApiTranslateResponse: Response from the API. JSON Object with
                translation of the text given

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api/translate'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        CustomHeaderAuth.apply(self.config, _request)
        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise ErrorsException('Bad Request', _response)
        elif _response.status_code == 426:
            raise M426ErrorException('Please use HTTPS protocol', _response)
        elif _response.status_code == 429:
            raise APIException('Too Many Requests', _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, ApiTranslateResponse.from_dictionary)

        return decoded
