"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkingStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const networking_1 = require("../constructs/networking");
/**
 * The NetworkingStack creates a [Networking](#@condensetech/cdk-constructs.Networking) construct.
 * It implements the INetworking interface so that it can be used in other constructs and stacks without requiring to access to the underlying construct.
 */
class NetworkingStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.construct = new networking_1.Networking(this, 'Networking', {
            vpcName: `${this.node.path}/VPC`,
            ...props,
        });
    }
    get hasPrivateSubnets() {
        return this.construct.hasPrivateSubnets;
    }
    get isolatedSubnets() {
        return this.construct.isolatedSubnets;
    }
    get privateSubnets() {
        return this.construct.privateSubnets;
    }
    get publicSubnets() {
        return this.construct.publicSubnets;
    }
    get vpc() {
        return this.construct.vpc;
    }
    get bastionHost() {
        return this.construct.bastionHost;
    }
}
exports.NetworkingStack = NetworkingStack;
_a = JSII_RTTI_SYMBOL_1;
NetworkingStack[_a] = { fqn: "@condensetech/cdk-constructs.NetworkingStack", version: "0.4.2" };
//# sourceMappingURL=data:application/json;base64,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