import * as cdk from 'aws-cdk-lib';
import * as ec2 from 'aws-cdk-lib/aws-ec2';
import { Construct } from 'constructs';
import { NetworkingProps } from '../constructs/networking';
import { INetworking } from '../interfaces';
/**
 * Properties for the NetworkingStack.
 */
export interface NetworkingStackProps extends NetworkingProps, cdk.StackProps {
}
/**
 * The NetworkingStack creates a [Networking](#@condensetech/cdk-constructs.Networking) construct.
 * It implements the INetworking interface so that it can be used in other constructs and stacks without requiring to access to the underlying construct.
 */
export declare class NetworkingStack extends cdk.Stack implements INetworking {
    private readonly construct;
    constructor(scope: Construct, id: string, props: NetworkingStackProps);
    get hasPrivateSubnets(): boolean;
    get isolatedSubnets(): ec2.SubnetSelection;
    get privateSubnets(): ec2.SubnetSelection | undefined;
    get publicSubnets(): ec2.SubnetSelection;
    get vpc(): ec2.IVpc;
    get bastionHost(): ec2.BastionHostLinux | undefined;
}
