"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EntrypointStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const entrypoint_1 = require("../constructs/entrypoint");
const monitoring_facade_1 = require("../constructs/monitoring/monitoring-facade");
/**
 * The EntrypointStack creates an [Entrypoint](#@condensetech/cdk-constructs.Entrypoint) construct and optionally defines the monitoring configuration.
 * It implements the IEntrypoint interface so that it can be used in other constructs and stacks without requiring to access to the underlying construct.
 */
class EntrypointStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.construct = new entrypoint_1.Entrypoint(this, 'Entrypoint', props);
        if (props.monitoring) {
            new monitoring_facade_1.MonitoringFacade(this, props.monitoring);
        }
    }
    allocateListenerRule(scope, id, props) {
        return this.construct.allocateListenerRule(scope, id, props);
    }
    get alb() {
        return this.construct.alb;
    }
    get domainName() {
        return this.construct.domainName;
    }
    get priorityAllocator() {
        return this.construct.priorityAllocator;
    }
    referenceListener(scope, id) {
        return this.construct.referenceListener(scope, id);
    }
}
exports.EntrypointStack = EntrypointStack;
_a = JSII_RTTI_SYMBOL_1;
EntrypointStack[_a] = { fqn: "@condensetech/cdk-constructs.EntrypointStack", version: "0.4.2" };
//# sourceMappingURL=data:application/json;base64,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