import { Stack, StackProps } from 'aws-cdk-lib';
import * as elb from 'aws-cdk-lib/aws-elasticloadbalancingv2';
import { Construct } from 'constructs';
import { EntrypointProps } from '../constructs/entrypoint';
import { MonitoringFacadeProps } from '../constructs/monitoring/monitoring-facade';
import { AllocateApplicationListenerRuleProps, IEntrypoint } from '../interfaces';
/**
 * Properties for the EntrypointStack.
 */
export interface EntrypointStackProps extends EntrypointProps, StackProps {
    /**
     * The monitoring configuration to apply to this stack.
     * @default - No monitoring.
     */
    readonly monitoring?: MonitoringFacadeProps;
}
/**
 * The EntrypointStack creates an [Entrypoint](#@condensetech/cdk-constructs.Entrypoint) construct and optionally defines the monitoring configuration.
 * It implements the IEntrypoint interface so that it can be used in other constructs and stacks without requiring to access to the underlying construct.
 */
export declare class EntrypointStack extends Stack implements IEntrypoint {
    private readonly construct;
    constructor(scope: Construct, id: string, props: EntrypointStackProps);
    allocateListenerRule(scope: Construct, id: string, props: AllocateApplicationListenerRuleProps): elb.ApplicationListenerRule;
    get alb(): elb.IApplicationLoadBalancer;
    get domainName(): string;
    get priorityAllocator(): import("../interfaces").IApplicationListenerPriorityAllocator;
    referenceListener(scope: Construct, id: string): elb.IApplicationListener;
}
