"use strict";
/* global fetch */
/// <reference lib="dom" />
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
/**
 * {
    "Records": [
        {
            "EventSource": "aws:sns",
            "EventVersion": "1.0",
            "EventSubscriptionArn": "arn:aws:sns:eu-south-1:975050211138:condense-alarms-topic:6ad71be8-03c9-44a2-8222-394f775cd4d6",
            "Sns": {
                "Type": "Notification",
                "MessageId": "e1a5d850-56a8-5cb9-873c-87524725ca49",
                "TopicArn": "arn:aws:sns:eu-south-1:975050211138:condense-alarms-topic",
                "Subject": "ALARM: \"SharedInfra-Alpha-Database-DatabaseInstanceObservabilityHighDatabaseConnec...\" in EU (Milan)",
                "Message": "{\"AlarmName\":\"SharedInfra-Alpha-Database-DatabaseInstanceObservabilityHighDatabaseConnectionsAlarm5CD1334F-FetIEoRn5hgP\",\"AlarmDescription\":null,\"AWSAccountId\":\"975050211138\",\"AlarmConfigurationUpdatedTimestamp\":\"2024-07-05T15:19:31.960+0000\",\"NewStateValue\":\"ALARM\",\"NewStateReason\":\"Threshold Crossed: 1 datapoint [8.0 (05/07/24 15:19:00)] was greater than or equal to the threshold (5.0).\",\"StateChangeTime\":\"2024-07-05T15:20:44.959+0000\",\"Region\":\"EU (Milan)\",\"AlarmArn\":\"arn:aws:cloudwatch:eu-south-1:975050211138:alarm:SharedInfra-Alpha-Database-DatabaseInstanceObservabilityHighDatabaseConnectionsAlarm5CD1334F-FetIEoRn5hgP\",\"OldStateValue\":\"OK\",\"OKActions\":[],\"AlarmActions\":[\"arn:aws:sns:eu-south-1:975050211138:condense-alarms-topic\"],\"InsufficientDataActions\":[],\"Trigger\":{\"MetricName\":\"DatabaseConnections\",\"Namespace\":\"AWS/RDS\",\"StatisticType\":\"Statistic\",\"Statistic\":\"AVERAGE\",\"Unit\":null,\"Dimensions\":[{\"value\":\"sharedinfra-alpha-databas-databaseinstance24d16791-o3f70cahozc6\",\"name\":\"DBInstanceIdentifier\"}],\"Period\":60,\"EvaluationPeriods\":1,\"ComparisonOperator\":\"GreaterThanOrEqualToThreshold\",\"Threshold\":5.0,\"TreatMissingData\":\"\",\"EvaluateLowSampleCountPercentile\":\"\"}}",
                "Timestamp": "2024-07-05T15:20:45.011Z",
                "SignatureVersion": "1",
                "Signature": "aivuzzWUm8LXSYb/GpN9LHIGFoJe5GHh9234RVcYhJueO0ewwWrHvNc95DnELMitINLXOPM8V3EDsD4cAyM9S+y4TSXTvnFwU/co8hIVz4dnAzX69mzYVspk6Pe5ybd9gsk5/a5IH30D5HI40R8HgLuyn4p94r9VgpM0xx/sgVvUR5AIUvF7fXkZmRD4VYDxj+QjGGUuG2lpVcjxIAGYhxmJ5ehrlGLg+f5tV+Ng197oJJNaZpYOw5v3XqRn+/ivwQvrC2eR3H1ws9Jm+UVdPhp2PAtadV19CIQD6hNN+kjW5Y0Kq2MY8kEcNeFnR19kKMDhkkqTjgs7g8hTCvRBng==",
                "SigningCertUrl": "https://sns.eu-south-1.amazonaws.com/SimpleNotificationService-976a9179f44bb8cd90ba2dfb685e68e3.pem",
                "UnsubscribeUrl": "https://sns.eu-south-1.amazonaws.com/?Action=Unsubscribe&SubscriptionArn=arn:aws:sns:eu-south-1:975050211138:condense-alarms-topic:6ad71be8-03c9-44a2-8222-394f775cd4d6",
                "MessageAttributes": {}
            }
        }
    ]
}
 */
async function handler(event) {
    const username = process.env.DISCORD_USERNAME;
    const webhook = process.env.DISCORD_WEBHOOK;
    if (!webhook) {
        throw new Error('DISCORD_WEBHOOK environment variable is required');
    }
    const payload = JSON.parse(event.Records[0].Sns.Message);
    await fetch(webhook, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({
            content: `ALARM on AWS ${payload.AWSAccountId} in ${payload.Region} - ${payload.AlarmDescription || payload.AlarmName}\n${payload.NewStateReason}`,
            ...(username ? { username } : {}),
        }),
    });
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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