"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuroraClusterStack = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("../constructs");
const monitoring_facade_1 = require("../constructs/monitoring/monitoring-facade");
/**
 * The AuroraClusterStack creates an [AuroraCluster](#@condensetech/cdk-constructs.AuroraCluster) construct and optionally defines the monitoring configuration.
 * It implements the IDatabase interface so that it can be used in other constructs and stacks without requiring to access to the underlying construct.
 */
class AuroraClusterStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.resource = new constructs_1.AuroraCluster(this, 'DatabaseCluster', props);
        if (props.monitoring) {
            new monitoring_facade_1.MonitoringFacade(this, props.monitoring);
        }
    }
    get endpoint() {
        return this.resource.endpoint;
    }
    get connections() {
        return this.resource.connections;
    }
    fetchSecret(scope, id) {
        return this.resource.fetchSecret(scope, id);
    }
}
exports.AuroraClusterStack = AuroraClusterStack;
_a = JSII_RTTI_SYMBOL_1;
AuroraClusterStack[_a] = { fqn: "@condensetech/cdk-constructs.AuroraClusterStack", version: "0.4.2" };
//# sourceMappingURL=data:application/json;base64,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