"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NaiveBasicAuthCloudfrontFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloudfront = require("aws-cdk-lib/aws-cloudfront");
function serializeExcludePaths(paths) {
    const serializedValues = paths.map(({ path, matchMode }) => {
        if (matchMode === 'regex') {
            if (!path.startsWith('/')) {
                return `/${path}/`;
            }
            return path.toString();
        }
        return `"${path}"`;
    });
    return `[${serializedValues.join(', ')}]`;
}
/**
 * A CloudFront function that implements a naive basic auth mechanism.
 * The function is naive because the basic auth string isn't treated as a secret and it's hardcoded in the function code.
 *
 * This function is useful for simple use cases where you need to protect a CloudFront distribution with basic auth. A typical use case is to ensure that a staging environment isn't indexed by crawlers (just in case robots.txt is totally ignored).
 */
class NaiveBasicAuthCloudfrontFunction extends cloudfront.Function {
    constructor(scope, id, props) {
        super(scope, id, {
            code: cloudfront.FunctionCode.fromInline(
            // js
            `function handler(event) {
        var request = event.request;
        var headers = request.headers;

        var authString = "Basic ${props.basicAuthString}";
        var excludePaths = ${serializeExcludePaths(props.excludePaths ?? [])};

        var isPathExcluded = excludePaths.some(function (path) {
          if (path instanceof RegExp) {
            return path.test(request.uri);
          }
          return path === request.uri;
        });

        var isPathProtected = !isPathExcluded;
        var isBasicAuthInvalid = typeof headers.authorization === "undefined" || headers.authorization.value !== authString;
        if (isPathProtected && isBasicAuthInvalid) {
          return {
            statusCode: 401,
            statusDescription: "Unauthorized",
            headers: { "www-authenticate": { value: "Basic" } }
          };
        }

        return request;
      }`),
        });
    }
}
exports.NaiveBasicAuthCloudfrontFunction = NaiveBasicAuthCloudfrontFunction;
_a = JSII_RTTI_SYMBOL_1;
NaiveBasicAuthCloudfrontFunction[_a] = { fqn: "@condensetech/cdk-constructs.NaiveBasicAuthCloudfrontFunction", version: "0.4.2" };
//# sourceMappingURL=data:application/json;base64,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