import * as cloudfront from 'aws-cdk-lib/aws-cloudfront';
import { Construct } from 'constructs';
/**
 * Exclusion path for the NaiveBasicAuthCloudfrontFunction
 */
export interface NaiveBasicAuthCloudfrontFunctionExcludedPath {
    /**
     * The path to exclude from basic auth.
     * @example
     * "/admin"
     * "/\/admin\\/.+/"
     */
    readonly path: string;
    /**
     * The match mode to use for the path:
     * - 'exact' for exact string match
     * - 'regex' for regex match
     * @default 'exact'
     */
    readonly matchMode?: 'exact' | 'regex';
}
/**
 * Props for the NaiveBasicAuthCloudfrontFunction construct
 */
export interface NaiveBasicAuthCloudfrontFunctionProps {
    /**
     * The basic auth string to use for checking basic auth credentials
     * You can generate a basic auth string using the following command: echo -n "$username:$password" | base64
     */
    readonly basicAuthString: string;
    /**
     * The paths to exclude from basic auth. Pass a string or regex to match the path. Strings are checked using === operator.
     * @default - no paths are excluded
     */
    readonly excludePaths?: Array<NaiveBasicAuthCloudfrontFunctionExcludedPath>;
}
/**
 * A CloudFront function that implements a naive basic auth mechanism.
 * The function is naive because the basic auth string isn't treated as a secret and it's hardcoded in the function code.
 *
 * This function is useful for simple use cases where you need to protect a CloudFront distribution with basic auth. A typical use case is to ensure that a staging environment isn't indexed by crawlers (just in case robots.txt is totally ignored).
 */
export declare class NaiveBasicAuthCloudfrontFunction extends cloudfront.Function {
    constructor(scope: Construct, id: string, props: NaiveBasicAuthCloudfrontFunctionProps);
}
