"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.alertAnnotations = exports.dashboardMillisecondsAxis = exports.dashboardSecondsAxis = exports.dashboardPercentAxis = exports.dashboardGenericAxis = exports.dashboardSectionTitle = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const dashboardSectionTitle = (title) => new aws_cdk_lib_1.aws_cloudwatch.TextWidget({
    markdown: `# ${title}`,
    width: 24,
});
exports.dashboardSectionTitle = dashboardSectionTitle;
exports.dashboardGenericAxis = {
    min: 0,
    showUnits: false,
};
exports.dashboardPercentAxis = {
    ...exports.dashboardGenericAxis,
    max: 100,
    label: '%',
};
exports.dashboardSecondsAxis = {
    ...exports.dashboardGenericAxis,
    label: 's',
};
exports.dashboardMillisecondsAxis = {
    ...exports.dashboardGenericAxis,
    label: 'ms',
};
const alertAnnotations = (thresholds) => thresholds
    .map(({ label, value, color }) => (value ? { label, value, color: color ?? '#ff0000' } : undefined))
    .filter(Boolean);
exports.alertAnnotations = alertAnnotations;
//# sourceMappingURL=data:application/json;base64,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