import * as cdk from 'aws-cdk-lib';
import { aws_rds as rds } from 'aws-cdk-lib';
import { IConstruct } from 'constructs';
import { ICondenseMonitoringFacade } from '../interfaces';
/**
 * The RdsInstanceMonitoringConfig defines the thresholds for the RDS instance monitoring.
 */
export interface RdsInstanceMonitoringConfig {
    /**
     * The CPU Utilization (%) threshold.
     * @default 90
     */
    readonly cpuUtilizationThreshold?: number;
    /**
     * The Max Connections threshold.
     * @default 50
     */
    readonly maxConnectionsThreshold?: number;
    /**
     * The EBS Byte Balance (%) threshold.
     * @default 10
     */
    readonly ebsByteBalanceThreshold?: number;
    /**
     * The EBS IO Balance (%) threshold.
     * @default 10
     */
    readonly ebsIoBalanceThreshold?: number;
    /**
     * The Freeable Memory threshold.
     * @default 100 MiB
     */
    readonly freeableMemoryThreshold?: cdk.Size;
    /**
     * The Free Storage Space threshold.
     * @default 100 MiB
     */
    readonly freeStorageSpaceThreshold?: cdk.Size;
    /**
     * The Read Latency threshold.
     * @default 20
     */
    readonly readLatencyThreshold?: number;
}
/**
 * The RdsInstanceMonitoringAspect iterates over the RDS instances and adds monitoring widgets and alarms.
 */
export declare class RdsInstanceMonitoringAspect implements cdk.IAspect {
    private readonly monitoringFacade;
    private readonly overriddenConfig;
    private readonly defaultConfig;
    constructor(monitoringFacade: ICondenseMonitoringFacade);
    visit(node: IConstruct): void;
    /**
     * Overrides the default configuration for the RDS instance.
     * @param node The RDS instance to monitor.
     * @param config The configuration to apply.
     */
    overrideConfig(node: rds.DatabaseInstance, config: RdsInstanceMonitoringConfig): void;
    private readConfig;
    private widgets;
    private alarms;
    private metrics;
}
