import * as cdk from 'aws-cdk-lib';
import { aws_ecs as ecs } from 'aws-cdk-lib';
import { IConstruct } from 'constructs';
import { ICondenseMonitoringFacade } from '../interfaces';
/**
 * The FargateServiceMonitoringConfig defines the thresholds for the Fargate service monitoring.
 */
export interface FargateServiceMonitoringConfig {
    /**
     * The CPU Utilization (%) threshold.
     * @default 90
     */
    readonly cpuUtilizationThreshold?: number;
    /**
     * The Memory Utilization (%) threshold.
     * @default 90
     */
    readonly memoryUtilization?: number;
}
/**
 * The FargateServiceMonitoringAspect iterates over the Fargate services and adds monitoring widgets and alarms.
 */
export declare class FargateServiceMonitoringAspect implements cdk.IAspect {
    private readonly monitoringFacade;
    private readonly overriddenConfig;
    private readonly defaultConfig;
    constructor(monitoringFacade: ICondenseMonitoringFacade);
    visit(node: IConstruct): void;
    /**
     * Overrides the default configuration for a specific Fargate service.
     * @param node The Fargate service to monitor.
     * @param config The configuration to apply.
     */
    overrideConfig(node: ecs.FargateService, config: FargateServiceMonitoringConfig): void;
    private readConfig;
    private widgets;
    private alarms;
    private metrics;
}
