"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildAlarms = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const buildAlarms = (props) => {
    const alarms = [];
    for (const alarm of props.alarms) {
        if (alarm.threshold === undefined) {
            continue;
        }
        alarms.push(new aws_cdk_lib_1.aws_cloudwatch.Alarm(props.node, alarm.alarmId, {
            alarmName: alarm.alarmName ?? `${alarm.alarmId}-${props.nodeIdentifier}`,
            metric: alarm.metric,
            evaluationPeriods: alarm.evaluationPeriods,
            threshold: alarm.threshold,
            comparisonOperator: alarm.comparisonOperator,
            alarmDescription: alarm.alarmDescription,
        }));
    }
    return alarms;
};
exports.buildAlarms = buildAlarms;
//# sourceMappingURL=data:application/json;base64,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