"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationListenerPriorityAllocator = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class ApplicationListenerPriorityAllocatorBase extends constructs_1.Construct {
    /**
     * Allocates the priority of an application listener rule
     * @param scope The scope of the construct.
     * @param id The ID of the listener rule to allocate the priority to.
     * @param props
     * @returns The allocated priority.
     */
    allocatePriority(scope, id, props) {
        const cr = new cdk.CustomResource(scope, id, {
            serviceToken: this.serviceToken,
            properties: {
                rulePath: `${cdk.Stack.of(scope).region}/${cdk.Stack.of(scope).stackName}/${scope.node.path}/${id}`,
                priority: props.priority,
            },
        });
        return cdk.Token.asNumber(cr.getAtt('priority'));
    }
}
/**
 * This custom resource allows to generate unique priorities for application listener rules.
 *
 * Consumers can allocate a priority to a listener rule by calling the `allocatePriority` method, ensuring that:
 * - if no priority is set, one will be generated
 * - if a priority is set, an error will be thrown if the priority is already taken
 */
class ApplicationListenerPriorityAllocator extends ApplicationListenerPriorityAllocatorBase {
    static fromServiceToken(scope, id, serviceToken) {
        class Imported extends ApplicationListenerPriorityAllocatorBase {
            constructor() {
                super(...arguments);
                this.serviceToken = serviceToken;
            }
        }
        return new Imported(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        const table = new aws_cdk_lib_1.aws_dynamodb.Table(this, 'Table', {
            tableName: `app_listener_priorities_${cdk.Names.uniqueResourceName(props.listener, { maxLength: 220 })}`,
            partitionKey: { name: 'pk', type: aws_cdk_lib_1.aws_dynamodb.AttributeType.STRING },
            removalPolicy: props.removalPolicy ?? cdk.RemovalPolicy.DESTROY,
        });
        const onEventHandler = new aws_cdk_lib_1.aws_lambda_nodejs.NodejsFunction(this, 'handler', {
            functionName: `app_listener_priority_alloc_${cdk.Names.uniqueResourceName(props.listener, { maxLength: 220 })}`,
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_20_X,
            environment: {
                LISTENER_ARN: props.listener.listenerArn,
                TABLE_NAME: table.tableName,
                PRIORITY_INIT: props?.priorityInitialValue?.toString() ?? '1',
            },
        });
        table.grantReadWriteData(onEventHandler);
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'Provider', {
            onEventHandler,
        });
        this.serviceToken = provider.serviceToken;
        new cdk.CfnOutput(this, 'ServiceToken', { value: this.serviceToken });
    }
}
exports.ApplicationListenerPriorityAllocator = ApplicationListenerPriorityAllocator;
_a = JSII_RTTI_SYMBOL_1;
ApplicationListenerPriorityAllocator[_a] = { fqn: "@condensetech/cdk-constructs.ApplicationListenerPriorityAllocator", version: "0.4.2" };
//# sourceMappingURL=data:application/json;base64,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