/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.Const;
import java.util.BitSet;
import vcf.GT;
import vcf.Marker;
import vcf.Markers;
import vcf.XGT1;

public final class XBasicGT1
implements XGT1 {
    private final int idIndex;
    private final Markers markers;
    private final BitSet missing1;
    private final BitSet missing2;
    private final BitSet allele1;
    private final BitSet allele2;
    private final BitSet isPhased;
    private final boolean isRefSample;

    public XBasicGT1(GT gT, int n) {
        this(gT, n, -1, -1);
    }

    public XBasicGT1(GT gT, int n, int n2, int n3) {
        int n4 = gT.markers().nMarkers();
        this.idIndex = gT.samples().idIndex(n);
        this.markers = gT.markers();
        this.missing1 = new BitSet(n4);
        this.missing2 = new BitSet(n4);
        this.allele1 = new BitSet(gT.markers().sumHaplotypeBits());
        this.allele2 = new BitSet(gT.markers().sumHaplotypeBits());
        this.isPhased = new BitSet(n4);
        this.isRefSample = n2 == -1 && n3 == -1 ? this.copyGL(gT, n) : this.useConstraintAndGL(gT, n, n2, n3);
    }

    private boolean copyGL(GT gT, int n) {
        int n2 = this.markers.nMarkers();
        for (int i = 0; i < n2; ++i) {
            int n3 = gT.allele1(i, n);
            int n4 = gT.allele2(i, n);
            XBasicGT1.setBits(this.markers, i, n3, this.allele1, this.missing1);
            XBasicGT1.setBits(this.markers, i, n4, this.allele2, this.missing2);
            if (!gT.isPhased(i, n)) continue;
            this.isPhased.set(i);
        }
        return gT.isPhased(n);
    }

    private boolean useConstraintAndGL(GT gT, int n, int n2, int n3) {
        int n4 = this.markers.nMarkers();
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            int n6 = gT.allele1(i, n);
            int n7 = gT.allele2(i, n);
            int n8 = XBasicGT1.transmittedAllele(gT, i, n2);
            int n9 = XBasicGT1.transmittedAllele(gT, i, n3);
            if ((n8 >= 0 || n9 >= 0) && XBasicGT1.isUnphasedConsistent(n6, n7, n8, n9)) {
                if (!XBasicGT1.isPhasedConsistent(n6, n7, n8, n9)) {
                    int n10 = n6;
                    n6 = n7;
                    n7 = n10;
                }
                if (n8 != -1) {
                    n6 = n8;
                }
                if (n9 != -1) {
                    n7 = n9;
                }
                if (n6 >= 0 && n7 >= 0) {
                    ++n5;
                    this.isPhased.set(i);
                }
            }
            XBasicGT1.setBits(this.markers, i, n6, this.allele1, this.missing1);
            XBasicGT1.setBits(this.markers, i, n7, this.allele2, this.missing2);
        }
        return n5 == n4;
    }

    private static boolean isUnphasedConsistent(int n, int n2, int n3, int n4) {
        return XBasicGT1.isPhasedConsistent(n, n2, n3, n4) || XBasicGT1.isPhasedConsistent(n, n2, n4, n3);
    }

    private static boolean isPhasedConsistent(int n, int n2, int n3, int n4) {
        return XBasicGT1.isConsistent(n, n3) && XBasicGT1.isConsistent(n2, n4);
    }

    private static boolean isConsistent(int n, int n2) {
        return n == -1 || n2 == -1 || n == n2;
    }

    private static int transmittedAllele(GT gT, int n, int n2) {
        if (n2 == -1) {
            return -1;
        }
        int n3 = gT.allele1(n, n2);
        return n3 >= 0 && n3 == gT.allele2(n, n2) ? n3 : -1;
    }

    private static void setBits(Markers markers, int n, int n2, BitSet bitSet, BitSet bitSet2) {
        if (n2 == -1) {
            bitSet2.set(n);
        } else {
            int n3 = 1;
            int n4 = markers.sumHaplotypeBits(n);
            int n5 = markers.sumHaplotypeBits(n + 1);
            for (int i = n4; i < n5; ++i) {
                boolean bl = (n2 & n3) == n3;
                bitSet.set(i, bl);
                n3 <<= 1;
            }
        }
    }

    private int allele(BitSet bitSet, int n) {
        int n2 = this.markers.sumHaplotypeBits(n);
        int n3 = this.markers.sumHaplotypeBits(n + 1);
        if (n3 == n2 + 1) {
            return bitSet.get(n2) ? 1 : 0;
        }
        int n4 = 0;
        int n5 = 1;
        for (int i = n2; i < n3; ++i) {
            if (bitSet.get(i)) {
                n4 += n5;
            }
            n5 <<= 1;
        }
        return n4;
    }

    @Override
    public boolean isRefSample() {
        return this.isRefSample;
    }

    @Override
    public float gl(int n, int n2, int n3) {
        boolean bl;
        if (n2 < 0 || n2 >= this.markers.marker(n).nAlleles()) {
            throw new IndexOutOfBoundsException(String.valueOf(this.allele1));
        }
        if (n3 < 0 || n3 >= this.markers.marker(n).nAlleles()) {
            throw new IndexOutOfBoundsException(String.valueOf(this.allele2));
        }
        int n4 = this.allele1(n);
        int n5 = this.allele2(n);
        boolean bl2 = bl = !(n4 != -1 && n4 != n2 || n5 != -1 && n5 != n3);
        if (!bl && !this.isPhased.get(n)) {
            bl = !(n4 != -1 && n4 != n3 || n5 != -1 && n5 != n2);
        }
        return bl ? 1.0f : 0.0f;
    }

    @Override
    public boolean isPhased(int n) {
        return this.isPhased.get(n);
    }

    @Override
    public int allele1(int n) {
        return this.missing1.get(n) ? -1 : this.allele(this.allele1, n);
    }

    @Override
    public int allele2(int n) {
        return this.missing2.get(n) ? -1 : this.allele(this.allele2, n);
    }

    @Override
    public int nMarkers() {
        return this.markers.nMarkers();
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public int idIndex() {
        return this.idIndex;
    }

    @Override
    public String toString() {
        int n = this.markers.nMarkers();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[XBasicGL1: nMarkers=");
        stringBuilder.append(n);
        stringBuilder.append(Const.nl);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.markers.marker(i));
            stringBuilder.append('\t');
            stringBuilder.append(this.allele1(i));
            stringBuilder.append(this.isPhased(i) ? (char)'|' : '/');
            stringBuilder.append(this.allele2(i));
            stringBuilder.append(Const.nl);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

