/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.Const;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import main.GenotypeValues;
import vcf.Marker;
import vcf.PhasedGT;
import vcf.VcfRecBuilder;

public final class VcfWriter {
    private static final String fileformat = "##fileformat=VCFv4.2";
    private static final String afInfo = "##INFO=<ID=AF,Number=A,Type=Float,Description=\"Estimated ALT Allele Frequencies\">";
    private static final String dr2Info = "##INFO=<ID=DR2,Number=1,Type=Float,Description=\"Dosage R-Squared: estimated squared correlation between estimated REF dose [P(RA) + 2*P(RR)] and true REF dose\">";
    private static final String impInfo = "##INFO=<ID=IMP,Number=0,Type=Flag,Description=\"Imputed marker\">";
    private static final String gtFormat = "##FORMAT=<ID=GT,Number=1,Type=String,Description=\"Genotype\">";
    private static final String dsFormat = "##FORMAT=<ID=DS,Number=A,Type=Float,Description=\"estimated ALT dose [P(RA) + P(AA)]\">";
    private static final String ap1Format = "##FORMAT=<ID=AP1,Number=A,Type=Float,Description=\"estimated ALT dose on first haplotype\">";
    private static final String ap2Format = "##FORMAT=<ID=AP2,Number=A,Type=Float,Description=\"estimated ALT dose on second haplotype\">";
    private static final String glFormat = "##FORMAT=<ID=GL,Number=G,Type=Float,Description=\"Log10-scaled Genotype Likelihood\">";
    private static final String gpFormat = "##FORMAT=<ID=GP,Number=G,Type=Float,Description=\"Estimated Genotype Probability\">";
    private static final String shortChromPrefix = "#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO";
    private static final String longChromPrefix = "#CHROM\tPOS\tID\tREF\tALT\tQUAL\tFILTER\tINFO\tFORMAT";

    private VcfWriter() {
    }

    public static void writeMetaLinesGT(String[] stringArray, String string, PrintWriter printWriter) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        VcfWriter.writeMetaLines(stringArray, string, bl, bl2, bl3, bl4, printWriter);
    }

    public static void writeMetaLines(String[] stringArray, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, PrintWriter printWriter) {
        printWriter.print(fileformat);
        printWriter.print(Const.nl);
        printWriter.print("##filedate=");
        printWriter.print(VcfWriter.now());
        printWriter.print(Const.nl);
        if (string != null) {
            printWriter.print("##source=\"");
            printWriter.print(string);
            printWriter.println("\"");
        }
        if (bl) {
            printWriter.println(afInfo);
            printWriter.println(dr2Info);
            printWriter.println(impInfo);
        }
        printWriter.println(gtFormat);
        if (bl) {
            printWriter.println(dsFormat);
        }
        if (bl2) {
            printWriter.println(ap1Format);
            printWriter.println(ap2Format);
        }
        if (bl3) {
            printWriter.println(gpFormat);
        }
        if (bl4) {
            printWriter.println(glFormat);
        }
        printWriter.print(longChromPrefix);
        for (String string2 : stringArray) {
            if (string2 == null) {
                throw new NullPointerException("id==null");
            }
            printWriter.print('\t');
            printWriter.print(string2);
        }
        printWriter.println();
    }

    private static String now() {
        String string = "yyyyMMdd";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(calendar.getTime());
    }

    public static void appendRecords(GenotypeValues genotypeValues, int n, int n2, PrintWriter printWriter) {
        if (n > n2) {
            throw new IllegalArgumentException("start=" + n + " end=" + n2);
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        VcfRecBuilder vcfRecBuilder = new VcfRecBuilder(12 * genotypeValues.nSamples());
        for (int i = n; i < n2; ++i) {
            Marker marker = genotypeValues.marker(i);
            vcfRecBuilder.reset(marker, bl, bl2);
            double[] dArray = new double[marker.nGenotypes()];
            int n3 = genotypeValues.nSamples();
            for (int j = 0; j < n3; ++j) {
                int n4;
                double d = 0.0;
                for (n4 = 0; n4 < dArray.length; ++n4) {
                    dArray[n4] = genotypeValues.value(i, j, n4);
                    d += dArray[n4];
                }
                n4 = 0;
                while (n4 < dArray.length) {
                    int n5 = n4++;
                    dArray[n5] = dArray[n5] / d;
                }
                vcfRecBuilder.addSampleData(dArray);
            }
            vcfRecBuilder.writeRec(printWriter, bl3);
        }
    }

    public static void appendRecords(PhasedGT phasedGT, int n, int n2, boolean bl, boolean bl2, PrintWriter printWriter) {
        if (n > n2) {
            throw new IllegalArgumentException("start=" + n + " end=" + n2);
        }
        boolean bl3 = false;
        VcfRecBuilder vcfRecBuilder = new VcfRecBuilder(4 * phasedGT.nSamples());
        for (int i = n; i < n2; ++i) {
            Marker marker = phasedGT.marker(i);
            vcfRecBuilder.reset(marker, bl, bl2);
            double[] dArray = new double[marker.nAlleles()];
            double[] dArray2 = new double[marker.nAlleles()];
            int n3 = phasedGT.nSamples();
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < dArray.length; ++k) {
                    dArray[k] = phasedGT.alProb1(i, j, k);
                    dArray2[k] = phasedGT.alProb2(i, j, k);
                }
                vcfRecBuilder.addSampleData(dArray, dArray2);
            }
            vcfRecBuilder.writeRec(printWriter, bl3);
        }
    }

    public static void printFixedFieldsGT(Marker marker, PrintWriter printWriter) {
        printWriter.print(marker);
        printWriter.print('\t');
        printWriter.print('.');
        printWriter.print('\t');
        printWriter.print("PASS");
        printWriter.print('\t');
        printWriter.print('.');
        printWriter.print('\t');
        printWriter.print("GT");
    }
}

