/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import vcf.GT;

public interface PhasedGT
extends GT {
    @Override
    default public boolean isPhased(int n, int n2) {
        if (n < 0 || n >= this.nMarkers()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (n2 < 0 || n2 >= this.nSamples()) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        return true;
    }

    @Override
    default public boolean isPhased(int n) {
        if (n < 0 || n >= this.nSamples()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return true;
    }

    @Override
    default public boolean isPhased() {
        return true;
    }

    default public float alProb1(int n, int n2, int n3) {
        if (n3 < 0 || n3 >= this.marker(n).nAlleles()) {
            throw new IndexOutOfBoundsException(String.valueOf(n3));
        }
        return n3 == this.allele1(n, n2) ? 1.0f : 0.0f;
    }

    default public float alProb2(int n, int n2, int n3) {
        if (n3 < 0 || n3 >= this.marker(n).nAlleles()) {
            throw new IndexOutOfBoundsException(String.valueOf(n3));
        }
        return n3 == this.allele2(n, n2) ? 1.0f : 0.0f;
    }

    default public float gtProb(int n, int n2, int n3, int n4) {
        return this.alProb1(n, n2, n3) * this.alProb2(n, n2, n4);
    }
}

