/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import vcf.GeneticMap;
import vcf.Marker;
import vcf.Markers;

public class MarkerMap
implements GeneticMap {
    private final GeneticMap genMap;
    private final Markers fwdMarkers;
    private final Markers revMarkers;
    private final double[] fwdGenPos;
    private final double[] revGenPos;
    private final MarkerMap revMarkerMap;

    public static MarkerMap create(GeneticMap geneticMap, Markers markers) {
        if (markers.marker(0).chromIndex() != markers.marker(markers.nMarkers() - 1).chromIndex()) {
            throw new IllegalArgumentException("multiple chromosomes");
        }
        MarkerMap markerMap = new MarkerMap(geneticMap, markers);
        return new MarkerMap(markerMap.reverse());
    }

    private MarkerMap(GeneticMap geneticMap, Markers markers) {
        this.genMap = geneticMap;
        this.fwdMarkers = markers;
        this.revMarkers = markers.reverse();
        this.fwdGenPos = geneticMap.genPos(markers);
        this.revGenPos = MarkerMap.reverse(this.fwdGenPos);
        this.revMarkerMap = null;
    }

    private MarkerMap(MarkerMap markerMap) {
        this.genMap = markerMap.genMap;
        this.fwdMarkers = markerMap.revMarkers;
        this.revMarkers = markerMap.fwdMarkers;
        this.fwdGenPos = markerMap.revGenPos;
        this.revGenPos = markerMap.fwdGenPos;
        this.revMarkerMap = markerMap;
    }

    private static double[] reverse(double[] dArray) {
        int n = dArray.length - 1;
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = dArray[n - i];
        }
        return dArray2;
    }

    public MarkerMap reverse() {
        return this.revMarkerMap == null ? new MarkerMap(this) : this.revMarkerMap;
    }

    public String chrom() {
        return this.fwdMarkers.marker(0).chrom();
    }

    public int chromIndex() {
        return this.fwdMarkers.marker(0).chromIndex();
    }

    @Override
    public int basePos(int n, double d) {
        return this.genMap.basePos(n, d);
    }

    @Override
    public double genPos(Marker marker) {
        return this.genMap.genPos(marker);
    }

    @Override
    public double genPos(int n, int n2) {
        return this.genMap.genPos(n, n2);
    }

    public int nMarkers() {
        return this.fwdMarkers.nMarkers();
    }

    public Markers markers() {
        return this.fwdMarkers;
    }

    public Marker marker(int n) {
        return this.fwdMarkers.marker(n);
    }

    public double genPos(int n) {
        return this.fwdGenPos[n];
    }

    public double[] genPos() {
        return (double[])this.fwdGenPos.clone();
    }
}

