/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import vcf.DuplicatesGTRec;

public interface GTRec
extends DuplicatesGTRec {
    public Samples samples();

    default public boolean isGTData() {
        return true;
    }

    default public float gl(int n, int n2, int n3) {
        boolean bl;
        int n4 = this.marker().nAlleles();
        if (n2 < 0 || n2 >= n4) {
            String string = "invalid alleles: (" + n2 + "): " + this.marker();
            throw new IllegalArgumentException(string);
        }
        if (n3 < 0 || n3 >= n4) {
            String string = "invalid alleles: (" + n3 + "): " + this.marker();
            throw new IllegalArgumentException(string);
        }
        int n5 = this.allele1(n);
        int n6 = this.allele2(n);
        boolean bl2 = bl = !(n5 != -1 && n5 != n2 || n6 != -1 && n6 != n3);
        if (!bl && !this.isPhased(n)) {
            bl = !(n5 != -1 && n5 != n3 || n6 != -1 && n6 != n2);
        }
        return bl ? 1.0f : 0.0f;
    }

    default public String toVcfRec() {
        StringBuilder stringBuilder = new StringBuilder(100);
        stringBuilder.append(this.marker());
        stringBuilder.append('\t');
        stringBuilder.append('.');
        stringBuilder.append('\t');
        stringBuilder.append("PASS");
        stringBuilder.append('\t');
        stringBuilder.append('.');
        stringBuilder.append('\t');
        stringBuilder.append("GT");
        int n = this.nSamples();
        for (int i = 0; i < n; ++i) {
            int n2 = this.allele1(i);
            int n3 = this.allele2(i);
            stringBuilder.append('\t');
            if (n2 == -1) {
                stringBuilder.append('.');
            } else {
                stringBuilder.append(n2);
            }
            stringBuilder.append(this.isPhased(i) ? (char)'|' : '/');
            if (n3 == -1) {
                stringBuilder.append('.');
                continue;
            }
            stringBuilder.append(n3);
        }
        return stringBuilder.toString();
    }
}

