/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import java.util.BitSet;
import vcf.GTRec;
import vcf.Marker;
import vcf.VcfHeader;
import vcf.VcfRecGTParser;
import vcf.VcfRecord;

public final class BitSetGT
implements GTRec {
    public static final String GT_FORMAT = "GT";
    private final int bitsPerAllele;
    private final Marker marker;
    private final Samples samples;
    private final boolean isRefData;
    private final BitSet allele1;
    private final BitSet allele2;
    private final BitSet isMissing1;
    private final BitSet isMissing2;
    private final BitSet isPhased;

    public BitSetGT(VcfHeader vcfHeader, String string) {
        VcfRecGTParser vcfRecGTParser = new VcfRecGTParser(vcfHeader, string);
        this.marker = vcfRecGTParser.marker();
        this.samples = vcfHeader.samples();
        this.bitsPerAllele = BitSetGT.bitsPerAllele(this.marker);
        this.allele1 = new BitSet(vcfHeader.nSamples() * this.bitsPerAllele);
        this.allele2 = new BitSet(vcfHeader.nSamples() * this.bitsPerAllele);
        this.isMissing1 = new BitSet(vcfHeader.nSamples());
        this.isMissing2 = new BitSet(vcfHeader.nSamples());
        this.isPhased = new BitSet(vcfHeader.nSamples());
        vcfRecGTParser.storeAlleles(this.allele1, this.allele2, this.isMissing1, this.isMissing2, this.isPhased);
        this.isRefData = BitSetGT.isRef(vcfHeader.nSamples(), this.isPhased, this.isMissing1, this.isMissing2);
    }

    private static boolean isRef(int n, BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        int n2 = bitSet2.cardinality() + bitSet3.cardinality();
        int n3 = n - bitSet.cardinality();
        return n2 == 0 && n3 == 0;
    }

    private BitSetGT(VcfRecord vcfRecord) {
        int n = vcfRecord.nSamples();
        if (n == 0) {
            String string = "missing sample data: " + vcfRecord;
            throw new IllegalArgumentException(string);
        }
        if (!vcfRecord.hasFormat(GT_FORMAT)) {
            String string = "missing GT FORMAT: " + vcfRecord;
            throw new IllegalArgumentException(string);
        }
        this.bitsPerAllele = BitSetGT.bitsPerAllele(vcfRecord.marker());
        this.samples = vcfRecord.samples();
        this.marker = vcfRecord.marker();
        this.isRefData = BitSetGT.isRef(vcfRecord);
        this.allele1 = new BitSet(n * this.bitsPerAllele);
        this.allele2 = new BitSet(n * this.bitsPerAllele);
        this.isMissing1 = new BitSet(n);
        this.isMissing2 = new BitSet(n);
        this.isPhased = new BitSet(n);
    }

    private static boolean isRef(VcfRecord vcfRecord) {
        int n = vcfRecord.nSamples();
        for (int i = 0; i < n; ++i) {
            if (vcfRecord.isPhased(i) && vcfRecord.allele1(i) >= 0 && vcfRecord.allele2(i) >= 0) continue;
            return false;
        }
        return true;
    }

    private static void setBits(VcfRecord vcfRecord, boolean bl, int n, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, BitSet bitSet4, BitSet bitSet5) {
        int n2 = 0;
        int n3 = 0;
        int n4 = vcfRecord.nSamples();
        for (int i = 0; i < n4; ++i) {
            int n5;
            int n6;
            if (bl && vcfRecord.isPhased(i)) {
                bitSet5.set(i);
            }
            int n7 = vcfRecord.allele1(i);
            int n8 = vcfRecord.allele2(i);
            if (n7 < 0) {
                bitSet3.set(i);
                n2 += n;
            } else {
                n6 = 1;
                for (n5 = 0; n5 < n; ++n5) {
                    if ((n7 & n6) == n6) {
                        bitSet.set(n2);
                    }
                    ++n2;
                    n6 <<= 1;
                }
            }
            if (n8 < 0) {
                bitSet4.set(i);
                n3 += n;
                continue;
            }
            n6 = 1;
            for (n5 = 0; n5 < n; ++n5) {
                if ((n8 & n6) == n6) {
                    bitSet2.set(n3);
                }
                ++n3;
                n6 <<= 1;
            }
        }
    }

    private static int bitsPerAllele(Marker marker) {
        int n = marker.nAlleles() - 1;
        int n2 = 32 - Integer.numberOfLeadingZeros(n);
        return n2;
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int nHaps() {
        return 2 * this.samples.nSamples();
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public boolean isPhased() {
        return this.isRefData;
    }

    @Override
    public boolean isGTData() {
        return true;
    }

    @Override
    public boolean isPhased(int n) {
        return this.isPhased.get(n);
    }

    @Override
    public int allele1(int n) {
        return this.isMissing1.get(n) ? -1 : this.allele(this.allele1, n);
    }

    @Override
    public int allele2(int n) {
        return this.isMissing2.get(n) ? -1 : this.allele(this.allele2, n);
    }

    @Override
    public float gl(int n, int n2, int n3) {
        boolean bl;
        if (n2 < 0 || n2 >= this.marker.nAlleles()) {
            String string = "invalid alleles: (" + n2 + "): " + this.marker;
            throw new IllegalArgumentException(string);
        }
        if (n3 < 0 || n3 >= this.marker.nAlleles()) {
            String string = "invalid alleles: (" + n3 + "): " + this.marker;
            throw new IllegalArgumentException(string);
        }
        int n4 = this.allele1(n);
        int n5 = this.allele2(n);
        boolean bl2 = bl = !(n4 != -1 && n4 != n2 || n5 != -1 && n5 != n3);
        if (!bl && !this.isPhased(n)) {
            bl = !(n4 != -1 && n4 != n3 || n5 != -1 && n5 != n2);
        }
        return bl ? 1.0f : 0.0f;
    }

    private int allele(BitSet bitSet, int n) {
        int n2 = this.bitsPerAllele * n;
        int n3 = n2 + this.bitsPerAllele;
        int n4 = 0;
        int n5 = 1;
        for (int i = n2; i < n3; ++i) {
            if (bitSet.get(i)) {
                n4 += n5;
            }
            n5 <<= 1;
        }
        return n4;
    }

    @Override
    public int nAlleles() {
        return this.marker().nAlleles();
    }

    public String toString() {
        return this.toVcfRec();
    }
}

