/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import java.util.Arrays;
import java.util.stream.Stream;
import vcf.GTRec;
import vcf.Marker;
import vcf.Markers;
import vcf.RefGT;
import vcf.RefGTRec;

public class BasicRefGT
implements RefGT {
    private final Markers markers;
    private final Samples samples;
    private final RefGTRec[] recs;

    public BasicRefGT(Markers markers, Samples samples, RefGTRec[] refGTRecArray) {
        BasicRefGT.checkData(markers, samples, refGTRecArray);
        this.markers = markers;
        this.samples = samples;
        this.recs = (RefGTRec[])refGTRecArray.clone();
    }

    public BasicRefGT(RefGTRec[] refGTRecArray) {
        this.samples = BasicRefGT.checkData(refGTRecArray);
        Marker[] markerArray = (Marker[])((Stream)Arrays.stream(refGTRecArray).parallel()).map(refGTRec -> refGTRec.marker()).toArray(Marker[]::new);
        this.markers = Markers.create(markerArray);
        this.recs = (RefGTRec[])refGTRecArray.clone();
    }

    private static Samples checkData(GTRec[] gTRecArray) {
        if (gTRecArray.length == 0) {
            String string = "Missing data in VCF file";
            throw new IllegalArgumentException(string);
        }
        Samples samples = gTRecArray[0].samples();
        for (int i = 0; i < gTRecArray.length; ++i) {
            if (!gTRecArray[i].samples().equals(samples)) {
                String string = "sample inconsistency at index " + i;
                throw new IllegalArgumentException(string);
            }
            if (gTRecArray[i].isPhased()) continue;
            String string = "non-reference data at marker index " + i;
            throw new IllegalArgumentException(string);
        }
        return samples;
    }

    private static void checkData(Markers markers, Samples samples, GTRec[] gTRecArray) {
        if (markers.nMarkers() != gTRecArray.length) {
            String string = "markers.nMarkers()=" + markers.nMarkers() + " refVcfRecs.length=" + gTRecArray.length;
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < gTRecArray.length; ++i) {
            if (!gTRecArray[i].samples().equals(samples)) {
                String string = "sample inconsistency at index " + i;
                throw new IllegalArgumentException(string);
            }
            if (!gTRecArray[i].marker().equals(markers.marker(i))) {
                String string = "marker inconsistency at index " + i;
                throw new IllegalArgumentException(string);
            }
            if (gTRecArray[i].isPhased()) continue;
            String string = "non-reference data at marker index " + i;
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    public int allele1(int n, int n2) {
        return this.recs[n].allele1(n2);
    }

    @Override
    public int allele2(int n, int n2) {
        return this.recs[n].allele2(n2);
    }

    @Override
    public int allele(int n, int n2) {
        return this.recs[n].allele(n2);
    }

    @Override
    public int nMarkers() {
        return this.markers.nMarkers();
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public int nHaps() {
        return 2 * this.samples.nSamples();
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public RefGTRec get(int n) {
        return this.recs[n];
    }
}

