/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.SampleFileIt;
import haplotype.HapPair;
import haplotype.WrappedHapPair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import main.Par;
import main.Pedigree;
import vcf.BasicGT;
import vcf.BasicRefGT;
import vcf.Data;
import vcf.GT;
import vcf.GTRec;
import vcf.GeneticMap;
import vcf.Markers;
import vcf.RefGT;
import vcf.RefGTRec;
import vcf.RestrictedVcfWindow;
import vcf.Window;
import vcf.WindowIt;
import vcf.XBasicGT;

public class AllData
implements Data {
    private final Pedigree ped;
    private int window = 0;
    private Window<RefGTRec> currentRefWindow;
    private RefGT refGT;
    private RefGT restrictRefGT;
    private GTRec[] targData;
    private int[] refIndices;
    private int[] targIndices;
    private GT targGTWindow;
    private final Samples allSamples;
    private final List<HapPair> refHapPairs;
    private final List<HapPair> targRefHapPairs;
    private final WindowIt<RefGTRec> refWindow;
    private final RestrictedVcfWindow targWindow;
    private int cumMarkerCnt = 0;

    public static AllData allData(Supplier<SampleFileIt<RefGTRec>> supplier, SampleFileIt<GTRec> sampleFileIt, Par par) {
        GeneticMap geneticMap = GeneticMap.geneticMap(par.map(), par.chromInt());
        WindowIt<RefGTRec> windowIt = WindowIt.newInstance(supplier, geneticMap, par.window(), par.overlap());
        if (windowIt.samples().nSamples() == 0 || sampleFileIt.samples().nSamples() == 0) {
            throw new IllegalArgumentException("nSamples==0");
        }
        RestrictedVcfWindow restrictedVcfWindow = new RestrictedVcfWindow(sampleFileIt);
        AllData allData = new AllData(par, windowIt, restrictedVcfWindow);
        assert (allData.canAdvanceWindow());
        allData.advanceWindowCm();
        return allData;
    }

    private AllData(Par par, WindowIt<RefGTRec> windowIt, RestrictedVcfWindow restrictedVcfWindow) {
        this.ped = new Pedigree(restrictedVcfWindow.samples(), par.ped());
        this.refWindow = windowIt;
        this.targWindow = restrictedVcfWindow;
        this.currentRefWindow = null;
        this.refGT = null;
        this.restrictRefGT = null;
        this.targData = new GTRec[0];
        this.refIndices = new int[0];
        this.targIndices = new int[0];
        this.targGTWindow = AllData.targGTWindow(restrictedVcfWindow.samples(), this.targData, this.ped);
        this.allSamples = AllData.allSamples(windowIt.samples(), restrictedVcfWindow.samples());
        this.refHapPairs = new ArrayList<HapPair>(0);
        this.targRefHapPairs = new ArrayList<HapPair>(0);
    }

    private static Samples allSamples(Samples samples, Samples samples2) {
        int n;
        int n2 = samples.nSamples();
        int n3 = samples2.nSamples();
        int[] nArray = new int[n2 + n3];
        for (n = 0; n < n3; ++n) {
            nArray[n] = samples2.idIndex(n);
        }
        for (n = 0; n < n2; ++n) {
            nArray[n3 + n] = samples.idIndex(n);
        }
        return new Samples(nArray);
    }

    private static GT targGTWindow(Samples samples, GTRec[] gTRecArray, Pedigree pedigree) {
        BasicGT basicGT = new BasicGT(samples, gTRecArray);
        return basicGT.isGTData() ? new XBasicGT(basicGT, pedigree) : basicGT;
    }

    @Override
    public Pedigree ped() {
        return this.ped;
    }

    @Override
    public GeneticMap genMap() {
        return this.refWindow.genMap();
    }

    @Override
    public boolean lastWindowOnChrom() {
        return this.currentRefWindow.lastWindowOnChrom();
    }

    @Override
    public boolean canAdvanceWindow() {
        return this.refWindow.hasNext();
    }

    @Override
    public void advanceWindowCm() {
        this.currentRefWindow = this.refWindow.next();
        this.cumMarkerCnt += this.currentRefWindow.nMarkers() - this.currentRefWindow.overlapEnd();
        RefGTRec[] refGTRecArray = this.currentRefWindow.recList().toArray(new RefGTRec[0]);
        this.refGT = new BasicRefGT(refGTRecArray);
        this.targData = this.targWindow.advanceWindow(this.refGT.markers());
        this.refIndices = AllData.refIndices(this.targData);
        this.targIndices = AllData.targetIndices(this.targData);
        this.targGTWindow = AllData.targGTWindow(this.targWindow.samples(), this.targData, this.refIndices, this.ped);
        ++this.window;
        this.setRefHaplotypes(this.refGT);
        this.setTargRefData(this.targGTWindow.markers(), refGTRecArray, this.refIndices);
    }

    @Override
    public int windowIndex() {
        return this.window;
    }

    private static int[] refIndices(GTRec[] gTRecArray) {
        int n = 0;
        for (GTRec gTRec : gTRecArray) {
            if (gTRec == null) continue;
            ++n;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < gTRecArray.length; ++i) {
            if (gTRecArray[i] == null) continue;
            nArray[n2++] = i;
        }
        if (n2 != nArray.length) {
            throw new IllegalStateException("vma modification detected");
        }
        return nArray;
    }

    private static int[] targetIndices(GTRec[] gTRecArray) {
        int[] nArray = new int[gTRecArray.length];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = gTRecArray[i] != null ? n++ : -1;
        }
        return nArray;
    }

    private static GT targGTWindow(Samples samples, GTRec[] gTRecArray, int[] nArray, Pedigree pedigree) {
        GTRec[] gTRecArray2 = new GTRec[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            gTRecArray2[i] = gTRecArray[nArray[i]];
        }
        BasicGT basicGT = new BasicGT(samples, gTRecArray2);
        return basicGT.isGTData() ? new XBasicGT(basicGT, pedigree) : basicGT;
    }

    private void setRefHaplotypes(RefGT refGT) {
        this.refHapPairs.clear();
        int n = refGT.nSamples();
        for (int i = 0; i < n; ++i) {
            this.refHapPairs.add(new WrappedHapPair(refGT, i));
        }
    }

    private void setTargRefData(Markers markers, RefGTRec[] refGTRecArray, int[] nArray) {
        int n;
        assert (markers.nMarkers() == nArray.length);
        this.targRefHapPairs.clear();
        RefGTRec[] refGTRecArray2 = new RefGTRec[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            refGTRecArray2[n] = refGTRecArray[nArray[n]];
        }
        this.restrictRefGT = new BasicRefGT(markers, this.refWindow.samples(), refGTRecArray2);
        int n2 = this.restrictRefGT.nSamples();
        for (n = 0; n < n2; ++n) {
            this.targRefHapPairs.add(new WrappedHapPair(this.restrictRefGT, n));
        }
    }

    @Override
    public int targetOverlap() {
        return this.targWindow.overlap();
    }

    @Override
    public int overlap() {
        return this.currentRefWindow.overlapEnd();
    }

    @Override
    public int nextOverlapStart() {
        return this.currentRefWindow.overlapStart();
    }

    @Override
    public int nTargetMarkers() {
        return this.targGTWindow.markers().nMarkers();
    }

    @Override
    public int nTargetMarkersSoFar() {
        return this.targWindow.cumMarkerCnt();
    }

    @Override
    public Markers targetMarkers() {
        return this.targGTWindow.markers();
    }

    @Override
    public int nMarkers() {
        return this.refGT.nMarkers();
    }

    @Override
    public int nMarkersSoFar() {
        return this.cumMarkerCnt;
    }

    @Override
    public Markers markers() {
        return this.refGT.markers();
    }

    @Override
    public int targetMarkerIndex(int n) {
        return this.targIndices[n];
    }

    @Override
    public int markerIndex(int n) {
        return this.refIndices[n];
    }

    @Override
    public int nTargetSamples() {
        return this.targGTWindow.nSamples();
    }

    @Override
    public Samples targetSamples() {
        return this.targGTWindow.samples();
    }

    @Override
    public int nRefSamples() {
        return this.refWindow.samples().nSamples();
    }

    @Override
    public Samples refSamples() {
        return this.refWindow.samples();
    }

    @Override
    public int nAllSamples() {
        return this.allSamples.nSamples();
    }

    @Override
    public Samples allSamples() {
        return this.allSamples;
    }

    @Override
    public GT targGT() {
        return this.targGTWindow;
    }

    @Override
    public List<HapPair> restrictedRefHapPairs() {
        return new ArrayList<HapPair>(this.targRefHapPairs);
    }

    @Override
    public List<HapPair> refHapPairs() {
        return new ArrayList<HapPair>(this.refHapPairs);
    }

    @Override
    public RefGT refGT() {
        return this.refGT;
    }

    @Override
    public RefGT restrictRefGT() {
        return this.restrictRefGT;
    }

    @Override
    public void close() {
        this.refWindow.close();
        this.targWindow.close();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(20);
        stringBuilder.append(this.getClass().toString());
        return stringBuilder.toString();
    }
}

